/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.record;

import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.BuildService;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.Target;
import org.restcomm.connect.rvd.model.client.Step;
import org.restcomm.connect.rvd.model.steps.record.RcmlRecordStep;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class RecordStep
extends Step {
    static final Logger logger = Logger.getLogger((String)BuildService.class.getName());
    String next;
    String method;
    Integer timeout;
    String finishOnKey;
    Integer maxLength;
    Boolean transcribe;
    String transcribeCallback;
    Boolean playBeep;

    public String getTranscribeCallback() {
        return this.transcribeCallback;
    }

    public void setTranscribeCallback(String transcribeCallback) {
        this.transcribeCallback = transcribeCallback;
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getFinishOnKey() {
        return this.finishOnKey;
    }

    public void setFinishOnKey(String finishOnKey) {
        this.finishOnKey = finishOnKey;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getTranscribe() {
        return this.transcribe;
    }

    public void setTranscribe(Boolean transcribe) {
        this.transcribe = transcribe;
    }

    public Boolean getPlayBeep() {
        return this.playBeep;
    }

    public void setPlayBeep(Boolean playBeep) {
        this.playBeep = playBeep;
    }

    public RcmlRecordStep render(Interpreter interpreter) {
        RcmlRecordStep rcmlStep = new RcmlRecordStep();
        if (!RvdUtils.isEmpty((String)this.getNext())) {
            String newtarget = interpreter.getTarget().getNodename() + "." + this.getName() + ".actionhandler";
            HashMap<String, String> pairs = new HashMap<String, String>();
            pairs.put("target", newtarget);
            String action = interpreter.buildAction(pairs);
            rcmlStep.setAction(action);
            rcmlStep.setMethod(this.getMethod());
        }
        rcmlStep.setFinishOnKey(this.getFinishOnKey());
        rcmlStep.setMaxLength(this.getMaxLength());
        rcmlStep.setPlayBeep(this.getPlayBeep());
        rcmlStep.setTimeout(this.getTimeout());
        rcmlStep.setTranscribe(this.getTranscribe());
        rcmlStep.setTranscribeCallback(this.getTranscribeCallback());
        return rcmlStep;
    }

    public void handleAction(Interpreter interpreter, Target originTarget) throws InterpreterException, StorageException {
        String Digits;
        String RecordingDuration;
        String restcommRecordingUrl;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"handling record action");
        }
        if (RvdUtils.isEmpty((String)this.getNext())) {
            throw new InterpreterException("'next' module is not defined for step " + this.getName());
        }
        String publicRecordingUrl = (String)interpreter.getRequestParams().getFirst((Object)"PublicRecordingUrl");
        if (publicRecordingUrl != null) {
            interpreter.getVariables().put("core_PublicRecordingUrl", publicRecordingUrl);
        }
        if ((restcommRecordingUrl = (String)interpreter.getRequestParams().getFirst((Object)"RecordingUrl")) != null) {
            try {
                String recordingUrl = interpreter.convertRecordingFileResourceHttp(restcommRecordingUrl, interpreter.getHttpRequest());
                interpreter.getVariables().put("core_RecordingUrl", recordingUrl);
            }
            catch (URISyntaxException e) {
                logger.warn((Object)("Cannot convert file URL to http URL - " + restcommRecordingUrl), (Throwable)e);
            }
        }
        if ((RecordingDuration = (String)interpreter.getRequestParams().getFirst((Object)"RecordingDuration")) != null) {
            interpreter.getVariables().put("core_RecordingDuration", RecordingDuration);
        }
        if ((Digits = (String)interpreter.getRequestParams().getFirst((Object)"Digits")) != null) {
            interpreter.getVariables().put("core_Digits", Digits);
        }
        interpreter.interpret(this.getNext(), null, null, originTarget);
    }
}

