/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.restcomm;

import java.net.URI;
import org.apache.http.impl.client.CloseableHttpClient;
import org.restcomm.connect.rvd.commons.http.CustomHttpClientBuilder;
import org.restcomm.connect.rvd.restcomm.RestcommClient;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class RestcommClient {
    private final URI restcommBaseUrl;
    private final String authHeader;
    CloseableHttpClient apacheClient;

    public RestcommClient(URI fallbackRestcommBaseUri, String authHeader, CustomHttpClientBuilder httpClientbuilder) throws RestcommClientInitializationException {
        if (RvdUtils.isEmpty((String)authHeader)) {
            throw new RestcommClientInitializationException("Restcomm client could not determine the user for accessing Restcomm");
        }
        this.authHeader = authHeader;
        this.restcommBaseUrl = fallbackRestcommBaseUri;
        this.apacheClient = httpClientbuilder.buildHttpClient();
    }

    public URI getRestcommBaseUrl() {
        return this.restcommBaseUrl;
    }

    public Request get(String path) {
        return new Request(this, "GET", path);
    }

    public Request post(String path) {
        return new Request(this, "POST", path);
    }

    public Request delete(String path) {
        return new Request(this, "DELETE", path);
    }

    static /* synthetic */ String access$000(RestcommClient x0) {
        return x0.authHeader;
    }
}

