/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.storage;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.exceptions.project.ProjectException;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.RappItem;
import org.restcomm.connect.rvd.model.client.Node;
import org.restcomm.connect.rvd.model.client.ProjectState;
import org.restcomm.connect.rvd.model.client.StateHeader;
import org.restcomm.connect.rvd.model.client.Step;
import org.restcomm.connect.rvd.model.client.WavItem;
import org.restcomm.connect.rvd.model.packaging.Rapp;
import org.restcomm.connect.rvd.model.server.ProjectOptions;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.BadProjectHeader;
import org.restcomm.connect.rvd.storage.exceptions.BadWorkspaceDirectoryStructure;
import org.restcomm.connect.rvd.storage.exceptions.ProjectAlreadyExists;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.storage.exceptions.WavItemDoesNotExist;
import org.restcomm.connect.rvd.utils.Zipper;
import org.restcomm.connect.rvd.utils.exceptions.ZipperException;

/*
 * Exception performing whole class analysis ignored.
 */
public class FsProjectStorage {
    static final Logger logger = Logger.getLogger((String)FsProjectStorage.class.getName());

    public static List<String> listProjectNames(WorkspaceStorage workspaceStorage) throws BadWorkspaceDirectoryStructure {
        ArrayList<String> items = new ArrayList<String>();
        File workspaceDir = new File(workspaceStorage.rootPath);
        if (workspaceDir.exists()) {
            File[] entries = workspaceDir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
            Arrays.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
            for (File entry : entries) {
                items.add(entry.getName());
            }
        } else {
            throw new BadWorkspaceDirectoryStructure();
        }
        return items;
    }

    public static InputStream getWav(String projectName, String filename, WorkspaceStorage workspaceStorage) throws StorageException {
        try {
            return workspaceStorage.loadStream("wavs" + File.separator + filename, projectName);
        }
        catch (StorageEntityNotFound e) {
            throw new WavItemDoesNotExist("Wav file does not exist - " + filename, (Throwable)e);
        }
    }

    public static String loadBootstrapInfo(String projectName, WorkspaceStorage workspaceStorage) throws StorageException {
        return workspaceStorage.loadEntityString("bootstrap", projectName);
    }

    public static void storeBootstrapInfo(String bootstrapInfo, String projectName, WorkspaceStorage workspaceStorage) throws StorageException {
        workspaceStorage.storeEntityString(bootstrapInfo, "bootstrap", projectName);
    }

    public static boolean hasBootstrapInfo(String projectName, WorkspaceStorage workspaceStorage) {
        return workspaceStorage.entityExists("bootstrap", projectName);
    }

    public static boolean hasRasInfo(String projectName, WorkspaceStorage workspaceStorage) {
        return workspaceStorage.entityExists("ras", projectName);
    }

    public static boolean hasPackagingInfo(String projectName, WorkspaceStorage workspaceStorage) {
        return workspaceStorage.entityExists("packaging", projectName);
    }

    public static Rapp loadRappFromPackaging(String projectName, WorkspaceStorage workspaceStorage) throws StorageException {
        return (Rapp)workspaceStorage.loadEntity("rapp", projectName + "/packaging", Rapp.class);
    }

    public static List<RappItem> listRapps(List<String> projectNames, WorkspaceStorage workspaceStorage, ProjectService projectService) throws StorageException, ProjectException {
        ArrayList<RappItem> rapps = new ArrayList<RappItem>();
        for (String projectName : projectNames) {
            Rapp rapp;
            RappItem item = new RappItem();
            item.setProjectName(projectName);
            if (FsProjectStorage.hasRasInfo((String)projectName, (WorkspaceStorage)workspaceStorage)) {
                item.setWasImported(Boolean.valueOf(true));
                rapp = (Rapp)workspaceStorage.loadEntity("rapp", projectName + "/ras", Rapp.class);
                item.setRappInfo(rapp.getInfo());
                boolean installedStatus = true;
                boolean configuredStatus = FsProjectStorage.hasBootstrapInfo((String)projectName, (WorkspaceStorage)workspaceStorage);
                boolean activeStatus = installedStatus && configuredStatus;
                RappItem.RappStatus[] statuses = new RappItem.RappStatus[]{RappItem.RappStatus.Installed, configuredStatus ? RappItem.RappStatus.Configured : RappItem.RappStatus.Unconfigured, activeStatus ? RappItem.RappStatus.Active : RappItem.RappStatus.Inactive};
                item.setStatus(statuses);
            } else {
                item.setWasImported(Boolean.valueOf(false));
            }
            if (FsProjectStorage.hasPackagingInfo((String)projectName, (WorkspaceStorage)workspaceStorage)) {
                item.setHasPackaging(Boolean.valueOf(true));
                rapp = (Rapp)workspaceStorage.loadEntity("rapp", projectName + "/packaging", Rapp.class);
                item.setRappInfo(rapp.getInfo());
            } else {
                item.setHasPackaging(Boolean.valueOf(false));
            }
            item.setHasBootstrap(Boolean.valueOf(FsProjectStorage.hasBootstrapInfo((String)projectName, (WorkspaceStorage)workspaceStorage)));
            item.setStartUrl(projectService.buildStartUrl(projectName));
            rapps.add(item);
        }
        return rapps;
    }

    public static ProjectOptions loadProjectOptions(String projectName, WorkspaceStorage workspaceStorage) throws StorageException {
        ProjectOptions projectOptions = (ProjectOptions)workspaceStorage.loadEntity("project", projectName + "/data", ProjectOptions.class);
        return projectOptions;
    }

    public static void storeProjectOptions(ProjectOptions projectOptions, String projectName, WorkspaceStorage workspaceStorage) throws StorageException {
        workspaceStorage.storeEntity((Object)projectOptions, ProjectOptions.class, "project", projectName + "/data");
    }

    public static void storeNodeStepnames(Node node, String projectName, WorkspaceStorage storage) throws StorageException {
        ArrayList<String> stepnames = new ArrayList<String>();
        for (Step step : node.getSteps()) {
            stepnames.add(step.getName());
        }
        storage.storeEntity(stepnames, node.getName() + ".node", projectName + "/data");
    }

    public static List<String> loadNodeStepnames(String projectName, String nodeName, WorkspaceStorage storage) throws StorageException {
        List stepnames = (List)storage.loadEntity(nodeName + ".node", projectName + "/data", new /* Unavailable Anonymous Inner Class!! */.getType());
        return stepnames;
    }

    public static void storeNodeStep(Step step, Node node, String projectName, WorkspaceStorage storage) throws StorageException {
        storage.storeEntity((Object)step, node.getName() + "." + step.getName(), projectName + "/data/");
    }

    public static ProjectSettings loadProjectSettings(String projectName, WorkspaceStorage storage) throws StorageException {
        return (ProjectSettings)storage.loadEntity("settings", projectName, ProjectSettings.class);
    }

    public static void storeProjectSettings(ProjectSettings projectSettings, String projectName, WorkspaceStorage storage) throws StorageException {
        storage.storeEntity((Object)projectSettings, "settings", projectName);
    }

    public static ProjectState loadProject(String projectName, WorkspaceStorage storage) throws StorageException {
        return (ProjectState)storage.loadEntity("state", projectName, ProjectState.class);
    }

    public static String loadProjectString(String projectName, WorkspaceStorage storage) throws StorageException {
        return storage.loadEntityString("state", projectName);
    }

    private static void buildDirStructure(ProjectState state, String name, WorkspaceStorage storage) {
        if ("voice".equals(state.getHeader().getProjectKind())) {
            File wavsDir = new File(storage.rootPath + "/" + name + "/" + "wavs");
            wavsDir.mkdir();
        }
    }

    public static void storeProject(boolean firstTime, ProjectState state, String projectName, WorkspaceStorage storage) throws StorageException {
        storage.storeEntity((Object)state, "state", projectName);
        if (firstTime) {
            FsProjectStorage.buildDirStructure((ProjectState)state, (String)projectName, (WorkspaceStorage)storage);
        }
    }

    public static StateHeader loadStateHeader(String projectName, WorkspaceStorage storage) throws StorageException {
        JsonParser parser = new JsonParser();
        String stateData = storage.loadEntityString("state", projectName);
        JsonElement header_element = parser.parse(stateData).getAsJsonObject().get("header");
        if (header_element == null) {
            throw new BadProjectHeader("No header found. This is probably an old project");
        }
        Gson gson = new Gson();
        StateHeader header = (StateHeader)gson.fromJson(header_element, StateHeader.class);
        return header;
    }

    public static boolean projectExists(String projectName, WorkspaceStorage workspaceStorage) {
        return workspaceStorage.entityExists(projectName, "");
    }

    public static void createProjectSlot(String projectName, WorkspaceStorage storage) throws StorageException {
        if (FsProjectStorage.projectExists((String)projectName, (WorkspaceStorage)storage)) {
            throw new ProjectAlreadyExists("Project '" + projectName + "' already exists");
        }
        String projectPath = storage.rootPath + File.separator + projectName;
        File projectDirectory = new File(projectPath);
        if (!projectDirectory.mkdir()) {
            throw new StorageException("Cannot create project directory. Don't know why - " + projectDirectory);
        }
    }

    public static void renameProject(String projectName, String newProjectName, WorkspaceStorage storage) throws StorageException {
        try {
            File sourceDir = new File(storage.rootPath + File.separator + projectName);
            File destDir = new File(storage.rootPath + File.separator + newProjectName);
            FileUtils.moveDirectory((File)sourceDir, (File)destDir);
        }
        catch (IOException e) {
            throw new StorageException("Error renaming directory '" + projectName + "' to '" + newProjectName + "'");
        }
    }

    public static void deleteProject(String projectName, WorkspaceStorage storage) throws StorageException {
        try {
            File projectDir = new File(storage.rootPath + File.separator + projectName);
            FileUtils.deleteDirectory((File)projectDir);
        }
        catch (IOException e) {
            throw new StorageException("Error removing directory '" + projectName + "'", (Throwable)e);
        }
    }

    public static InputStream archiveProject(String projectName, WorkspaceStorage storage) throws StorageException {
        File tempFile;
        String path = storage.rootPath + File.separator + projectName;
        try {
            tempFile = File.createTempFile("RVDprojectArchive", ".zip");
        }
        catch (IOException e1) {
            throw new StorageException("Error creating temp file for archiving project " + projectName, (Throwable)e1);
        }
        try {
            FileInputStream archiveStream;
            Zipper zipper = new Zipper(tempFile);
            zipper.addDirectoryRecursively(path, false);
            zipper.finish();
            FileInputStream fileInputStream = archiveStream = new FileInputStream(tempFile);
            return fileInputStream;
        }
        catch (ZipperException e) {
            throw new StorageException("Error archiving " + projectName, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new StorageException("This is weird. Can't find the temp file i just created for archiving project " + projectName, (Throwable)e);
        }
        finally {
            tempFile.delete();
        }
    }

    public static String getAvailableProjectName(String projectName, WorkspaceStorage storage) throws StorageException {
        if (projectName == null || "".equals(projectName)) {
            projectName = "Unititled";
        }
        String baseProjectName = projectName;
        for (int counter = 1; counter < 50; ++counter) {
            if (!FsProjectStorage.projectExists((String)projectName, (WorkspaceStorage)storage)) {
                return projectName;
            }
            projectName = baseProjectName + " " + counter;
        }
        throw new StorageException("Can't find an available project name for base name '" + projectName + "'");
    }

    public static void importProjectFromDirectory(File sourceProjectDirectory, String projectName, boolean overwrite, WorkspaceStorage storage) throws StorageException {
        try {
            FsProjectStorage.createProjectSlot((String)projectName, (WorkspaceStorage)storage);
        }
        catch (ProjectAlreadyExists e) {
            if (!overwrite) {
                throw e;
            }
            File destProjectDirectory = new File(storage.rootPath + File.separator + projectName);
            try {
                FileUtils.cleanDirectory((File)destProjectDirectory);
                FileUtils.copyDirectory((File)sourceProjectDirectory, (File)destProjectDirectory);
            }
            catch (IOException e1) {
                throw new StorageException("Error importing project '" + projectName + "' from directory: " + sourceProjectDirectory);
            }
        }
    }

    private static String getProjectBasePath(String projectName, WorkspaceStorage storage) {
        return storage.rootPath + File.separator + projectName;
    }

    private static String getProjectWavsPath(String projectName, WorkspaceStorage storage) {
        return FsProjectStorage.getProjectBasePath((String)projectName, (WorkspaceStorage)storage) + File.separator + "wavs";
    }

    public static void storeWav(String projectName, String wavname, File sourceWavFile, WorkspaceStorage storage) throws StorageException {
        String destWavPathname = FsProjectStorage.getProjectWavsPath((String)projectName, (WorkspaceStorage)storage) + File.separator + wavname;
        try {
            FileUtils.copyFile((File)sourceWavFile, (File)new File(destWavPathname));
        }
        catch (IOException e) {
            throw new StorageException("Error coping wav file into project " + projectName + ": " + sourceWavFile + " -> " + destWavPathname, (Throwable)e);
        }
    }

    public static void storeWav(String projectName, String wavname, InputStream wavStream, WorkspaceStorage storage) throws StorageException {
        String wavPathname = FsProjectStorage.getProjectWavsPath((String)projectName, (WorkspaceStorage)storage) + File.separator + wavname;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing wav file to " + wavPathname));
        }
        try {
            FileUtils.copyInputStreamToFile((InputStream)wavStream, (File)new File(wavPathname));
        }
        catch (IOException e) {
            throw new StorageException("Error writing to " + wavPathname, (Throwable)e);
        }
    }

    public static List<WavItem> listWavs(String projectName, WorkspaceStorage storage) throws StorageException {
        ArrayList<WavItem> items = new ArrayList<WavItem>();
        File wavsDir = new File(FsProjectStorage.getProjectWavsPath((String)projectName, (WorkspaceStorage)storage));
        if (wavsDir.exists()) {
            File[] entries = wavsDir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
            Arrays.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
            for (File entry : entries) {
                WavItem item = new WavItem();
                item.setFilename(entry.getName());
                items.add(item);
            }
        }
        return items;
    }

    public static List<WavItem> listBundledWavs(RvdContext rvdContext) {
        ArrayList<WavItem> items = new ArrayList<WavItem>();
        String contextRealPath = rvdContext.getServletContext().getRealPath("/");
        String audioRealPath = contextRealPath + "audio";
        String contextPath = rvdContext.getServletContext().getContextPath();
        File dir = new File(audioRealPath);
        Collection audioFiles = FileUtils.listFiles((File)dir, (IOFileFilter)new SuffixFileFilter(".wav"), (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File anyFile : audioFiles) {
            WavItem item = new WavItem();
            String itemRelativePath = anyFile.getPath().substring(contextRealPath.length());
            String presentationName = anyFile.getPath().substring(contextRealPath.length() + "audio".length());
            item.setUrl(contextPath + "/" + itemRelativePath);
            item.setFilename(presentationName);
            items.add(item);
        }
        return items;
    }

    public static void deleteWav(String projectName, String wavname, WorkspaceStorage storage) throws WavItemDoesNotExist {
        String filepath = FsProjectStorage.getProjectWavsPath((String)projectName, (WorkspaceStorage)storage) + File.separator + wavname;
        File wavfile = new File(filepath);
        if (wavfile.delete()) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)("Deleted " + wavname + " from " + projectName + " app"));
            }
        } else {
            throw new WavItemDoesNotExist("Wav file does not exist - " + filepath);
        }
    }

    public static void storeRapp(Rapp rapp, String projectName, WorkspaceStorage storage) throws StorageException {
        storage.storeEntity((Object)rapp, rapp.getClass(), "rapp", projectName + "/ras");
    }

    public static Rapp loadRapp(String projectName, WorkspaceStorage storage) throws StorageException {
        return (Rapp)storage.loadEntity("rapp", projectName + "/ras", Rapp.class);
    }

    public static void backupProjectState(String projectName, WorkspaceStorage storage) throws StorageException {
        File sourceStateFile = new File(storage.rootPath + File.separator + projectName + File.separator + "state");
        File backupStateFile = new File(storage.rootPath + File.separator + projectName + File.separator + "state" + ".old");
        try {
            FileUtils.copyFile((File)sourceStateFile, (File)backupStateFile);
        }
        catch (IOException e) {
            throw new StorageException("Error creating state file backup: " + backupStateFile);
        }
    }

    public static void updateProjectState(String projectName, String newState, WorkspaceStorage storage) throws StorageException {
        try {
            FileOutputStream stateFile_os = new FileOutputStream(storage.rootPath + File.separator + projectName + File.separator + "state");
            IOUtils.write((String)newState, (OutputStream)stateFile_os, (Charset)Charset.forName("UTF-8"));
            stateFile_os.close();
        }
        catch (FileNotFoundException e) {
            throw new StorageException("Error updating state file for project '" + projectName + "'", (Throwable)e);
        }
        catch (IOException e) {
            throw new StorageException("Error updating state file for project '" + projectName + "'", (Throwable)e);
        }
    }

    public static String loadStep(String projectName, String nodeName, String stepName, WorkspaceStorage storage) throws StorageException {
        return storage.loadEntityString(nodeName + "." + stepName, projectName + "/data");
    }
}

