/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.upgrade;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.upgrade.ProjectUpgrader;

public class ProjectUpgrader714To10
implements ProjectUpgrader {
    static final Logger logger = Logger.getLogger((String)ProjectUpgrader714To10.class.getName());

    public JsonElement upgrade(String source) {
        JsonParser parser = new JsonParser();
        JsonElement sourceRoot = parser.parse(source);
        JsonElement targetRoot = this.upgrade(sourceRoot);
        return targetRoot;
    }

    public JsonElement upgrade(JsonElement sourceElement) {
        JsonObject source = sourceElement.getAsJsonObject();
        JsonObject target = new JsonObject();
        target.add("lastStepId", source.get("lastStepId"));
        target.add("lastNodeId", source.get("lastNodeId"));
        JsonObject t = new JsonObject();
        t.addProperty("activeNode", (Number)0);
        target.add("iface", (JsonElement)t);
        t = new JsonObject();
        t.addProperty("projectKind", "voice");
        t.addProperty("version", "1.0");
        t.add("startNodeName", source.get("startNodeName"));
        target.add("header", (JsonElement)t);
        JsonArray tNodes = new JsonArray();
        for (JsonElement sourceNode : source.getAsJsonArray("nodes")) {
            JsonObject tNode = new JsonObject();
            JsonObject s = sourceNode.getAsJsonObject();
            tNode.add("name", s.get("name"));
            tNode.add("label", s.get("label"));
            tNode.addProperty("kind", "voice");
            tNode.add("iface", (JsonElement)new JsonObject());
            JsonObject sourceSteps = s.getAsJsonObject("steps");
            JsonArray targetSteps = new JsonArray();
            for (JsonElement stepNameElement : s.getAsJsonArray("stepnames")) {
                String stepName = stepNameElement.getAsString();
                JsonElement tStep = this.upgradeStep(sourceSteps.get(stepName));
                targetSteps.add(tStep);
            }
            tNode.add("steps", (JsonElement)targetSteps);
            tNodes.add((JsonElement)tNode);
        }
        target.add("nodes", (JsonElement)tNodes);
        return target;
    }

    private JsonElement upgradeStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        String kind = o.get("kind").getAsString();
        if ("say".equals(kind)) {
            return this.upgradeSayStep(sourceStep);
        }
        if ("play".equals(kind)) {
            return this.upgradePlayStep(sourceStep);
        }
        if ("gather".equals(kind)) {
            return this.upgradeGatherStep(sourceStep);
        }
        if ("dial".equals(kind)) {
            return this.upgradeDialStep(sourceStep);
        }
        if ("redirect".equals(kind)) {
            return this.upgradeRedirectStep(sourceStep);
        }
        if ("hungup".equals(kind)) {
            return this.upgradeHungupStep(sourceStep);
        }
        if ("externalService".equals(kind)) {
            return this.upgradeExternalServiceStep(sourceStep);
        }
        if ("reject".equals(kind)) {
            return this.upgradeRejectStep(sourceStep);
        }
        if ("pause".equals(kind)) {
            return this.upgradePauseStep(sourceStep);
        }
        if ("sms".equals(kind)) {
            return this.upgradeSmsStep(sourceStep);
        }
        if ("email".equals(kind)) {
            return this.upgradeEmailStep(sourceStep);
        }
        if ("record".equals(kind)) {
            return this.upgradeRecordStep(sourceStep);
        }
        if ("fax".equals(kind)) {
            return this.upgradeFaxStep(sourceStep);
        }
        return sourceStep;
    }

    private JsonElement upgradeSayStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        t.add("phrase", o.get("phrase"));
        if (o.get("voice") != null && !o.get("voice").isJsonNull() && !o.get("voice").getAsString().equals("")) {
            t.add("voice", o.get("voice"));
        }
        if (o.get("loop") != null && !o.get("loop").isJsonNull()) {
            t.add("loop", o.get("loop"));
        }
        if (o.get("language") != null && !o.get("language").isJsonNull() && !o.get("language").getAsString().equals("")) {
            t.add("language", o.get("language"));
        }
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradePlayStep(JsonElement sourceSay) {
        JsonObject o = sourceSay.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        if (o.get("loop") != null && !o.get("loop").isJsonNull()) {
            t.add("loop", o.get("loop"));
        }
        t.add("playType", o.get("playType"));
        String wavUrl = "";
        if (o.get("wavUrl") != null && o.get("wavUrl").getAsJsonPrimitive().isString()) {
            wavUrl = o.get("wavUrl").getAsJsonPrimitive().getAsString();
        }
        JsonObject remote = new JsonObject();
        remote.addProperty("wavUrl", wavUrl);
        t.add("remote", (JsonElement)remote);
        String wavLocalFilename = "";
        if (o.get("wavLocalFilename") != null && o.get("wavLocalFilename").isJsonPrimitive() && o.get("wavLocalFilename").getAsJsonPrimitive().isString()) {
            wavLocalFilename = o.get("wavLocalFilename").getAsJsonPrimitive().getAsString();
        }
        JsonObject local = new JsonObject();
        remote.addProperty("wavLocalFilename", wavLocalFilename);
        t.add("local", (JsonElement)local);
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeGatherStep(JsonElement source) {
        JsonObject o = source.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        t.add("method", o.get("method"));
        if (o.get("timeout") != null && o.get("timeout").isJsonPrimitive() && o.get("timeout").getAsJsonPrimitive().isNumber()) {
            t.add("timeout", o.get("timeout"));
        }
        if (o.get("finishOnKey") != null && !o.get("finishOnKey").isJsonNull() && !"".equals(o.get("finishOnKey").getAsString())) {
            t.add("finishOnKey", o.get("finishOnKey"));
        }
        if (o.get("numDigits") != null && o.get("numDigits").isJsonPrimitive() && o.get("numDigits").getAsJsonPrimitive().isNumber()) {
            t.add("numDigits", o.get("numDigits"));
        }
        t.add("gatherType", o.get("gatherType"));
        JsonObject collectdigits = new JsonObject();
        collectdigits.add("next", o.get("next"));
        collectdigits.add("collectVariable", o.get("collectVariable"));
        collectdigits.addProperty("scope", "module");
        t.add("collectdigits", (JsonElement)collectdigits);
        JsonObject menu = new JsonObject();
        menu.add("mappings", o.get("mappings"));
        t.add("menu", (JsonElement)menu);
        JsonObject sourceSteps = o.getAsJsonObject("steps");
        JsonArray targetSteps = new JsonArray();
        for (JsonElement stepNameElement : o.getAsJsonArray("stepnames")) {
            String stepName = stepNameElement.getAsString();
            JsonElement tStep = this.upgradeStep(sourceSteps.get(stepName));
            targetSteps.add(tStep);
        }
        t.add("steps", (JsonElement)targetSteps);
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeDialStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        String dialType = o.get("dialType").getAsString();
        JsonObject noun = new JsonObject();
        if ("number".equals(dialType)) {
            noun.addProperty("dialType", "number");
            noun.add("destination", o.get("number"));
        } else if ("client".equals(dialType)) {
            noun.addProperty("dialType", "client");
            noun.add("destination", o.get("client"));
        } else if ("conference".equals(dialType)) {
            noun.addProperty("dialType", "conference");
            noun.add("destination", o.get("conference"));
        } else if ("sipuri".equals(dialType)) {
            noun.addProperty("dialType", "sipuri");
            noun.add("destination", o.get("sipuri"));
        }
        JsonArray dialNouns = new JsonArray();
        dialNouns.add((JsonElement)noun);
        t.add("dialNouns", (JsonElement)dialNouns);
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeRedirectStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        String url = null;
        if (o.get("url").isJsonPrimitive() && !"".equals(o.get("url").getAsString())) {
            url = o.get("url").getAsString();
        }
        t.add("url", o.get(url));
        String method = null;
        if (o.get("method") != null && o.get("method").isJsonPrimitive() && !"".equals(o.get("method").getAsString())) {
            method = o.get("method").getAsString();
        }
        t.add("method", o.get(method));
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeHungupStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeExternalServiceStep(JsonElement sourceStep) {
        JsonObject o;
        JsonObject t = o = sourceStep.getAsJsonObject();
        o.remove("nextVariable");
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeRejectStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        if (o.get("reason").isJsonPrimitive() && !"".equals(o.get("reason").getAsString())) {
            t.add("reason", o.get("reason"));
        }
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradePauseStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        if (o.get("length") != null && o.get("length").isJsonPrimitive() && o.get("length").getAsJsonPrimitive().isNumber()) {
            t.add("length", o.get("length"));
        }
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeSmsStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = o;
        if (t.get("next").isJsonPrimitive() && "".equals(t.get("next").getAsString())) {
            t.add("next", null);
        }
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeRecordStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = new JsonObject();
        t.add("name", o.get("name"));
        t.add("kind", o.get("kind"));
        t.add("label", o.get("label"));
        t.add("title", o.get("title"));
        if (o.get("next") != null && o.get("next").isJsonPrimitive() && "".equals(o.get("next").getAsString())) {
            t.add("next", null);
        } else {
            t.add("next", o.get("next"));
        }
        t.add("method", o.get("method"));
        if (o.get("timeout") != null && !o.get("timeout").isJsonNull()) {
            t.add("timeout", o.get("timeout"));
        }
        if (o.get("finishOnKey") != null && !o.get("finishOnKey").isJsonNull()) {
            t.add("finishOnKey", o.get("finishOnKey"));
        }
        if (o.get("maxLength") != null && !o.get("maxLength").isJsonNull()) {
            t.add("maxLength", o.get("maxLength"));
        }
        if (o.get("transcribe") != null && !o.get("transcribe").isJsonNull()) {
            t.add("transcribe", o.get("transcribe"));
        }
        if (o.get("transcribeCallback") != null && !o.get("transcribeCallback").isJsonNull()) {
            t.add("transcribeCallback", o.get("transcribeCallback"));
        }
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeFaxStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = o;
        if (t.get("next").isJsonPrimitive() && "".equals(t.get("next").getAsString())) {
            t.add("next", null);
        }
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    private JsonElement upgradeEmailStep(JsonElement sourceStep) {
        JsonObject o = sourceStep.getAsJsonObject();
        JsonObject t = o;
        if (t.get("next").isJsonPrimitive() && "".equals(t.get("next").getAsString())) {
            t.add("next", null);
        }
        t.add("iface", (JsonElement)new JsonObject());
        return t;
    }

    public String getResultingVersion() {
        return "1.0";
    }
}

