/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.restcomm.connect.rvd.exceptions.RvdException;

public class RvdUtils {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    public static File createTempDir() throws RvdException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new RvdException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean isEmpty(Boolean value) {
        return value == null || value == false;
    }

    public static boolean safeEquals(String value1, String value2) {
        return value1 == null ? value1 == value2 : value1.equals(value2);
    }

    public static Map<String, String> reduceHttpRequestParameterMap(Map<String, String[]> requestMap) {
        HashMap<String, String> reducedMap = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : requestMap.entrySet()) {
            reducedMap.put(entry.getKey(), entry.getValue()[0]);
        }
        return reducedMap;
    }

    public static String buildHttpAuthorizationToken(String username, String password) {
        byte[] usernamePassBytes = (username + ":" + password).getBytes(Charset.forName("UTF-8"));
        String authenticationToken = Base64.encodeBase64String((byte[])usernamePassBytes);
        return authenticationToken;
    }

    public static String myUrlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

