/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.util.regex.Pattern;
import org.eclipse.aether.artifact.Artifact;

public class PromotedDependency {
    private String groupId;
    private String artifactId;
    private String type;
    private String classifier;
    private String version;
    private Pattern groupIdPattern;
    private Pattern artifactIdPattern;
    private Pattern typePattern;
    private Pattern classifierPattern;
    private Pattern versionPattern;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        this.groupIdPattern = PromotedDependency.asPattern(groupId);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        this.artifactIdPattern = PromotedDependency.asPattern(artifactId);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.typePattern = PromotedDependency.asPattern(type);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
        this.classifierPattern = PromotedDependency.asPattern(classifier);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.versionPattern = PromotedDependency.asPattern(version);
    }

    public boolean matches(Artifact artifact) {
        return PromotedDependency.matches(this.groupIdPattern, artifact.getGroupId()) && PromotedDependency.matches(this.artifactIdPattern, artifact.getArtifactId()) && PromotedDependency.matches(this.typePattern, artifact.getExtension()) && PromotedDependency.matches(this.classifierPattern, artifact.getClassifier()) && PromotedDependency.matches(this.versionPattern, artifact.getBaseVersion());
    }

    private static boolean matches(Pattern pattern, String string) {
        String string2 = string = string == null ? "" : string;
        if (pattern == null) {
            return true;
        }
        return pattern.matcher(string).matches();
    }

    private static Pattern asPattern(String value) {
        if (value == null) {
            return null;
        }
        if (value.charAt(0) == '/' && value.charAt(value.length() - 1) == '/') {
            return Pattern.compile(value.substring(1, value.length() - 1));
        }
        return Pattern.compile(Pattern.quote(value));
    }
}

