/*
 * $Id$
 *
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.cdk.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.faces.component.behavior.ClientBehavior;
import javax.faces.el.MethodBinding;

/**
 * <p class="changed_added_4_0">
 * Used to define Java class field or bean property getter method as JSF attribute. It used on the abstract method, all
 * necessary code for attribute, including state save/restore code, will be generated by CDK.
 * </p>
 *
 * @author asmirnov@exadel.com
 *
 */
@Retention(RetentionPolicy.CLASS)
@Target({ ElementType.FIELD, ElementType.METHOD })
@Inherited
public @interface Attribute {
    /**
     * <p class="changed_added_4_0">
     * Restricts attribute to literal values only ( no EL expressions ).
     * </p>
     *
     * @return
     */
    boolean literal() default false;

    /**
     * <p class="changed_added_4_0">
     * Tells CDK to not include attribute in the VDL tag.
     * </p>
     *
     * @return
     */
    boolean hidden() default false;

    /**
     * <p class="changed_added_4_0">
     * Marks attribute as read-only ( no setter method ).
     * </p>
     *
     * @return
     */
    boolean readOnly() default false;

    // boolean transient() default false;

    /**
     * <p class="changed_added_4_0">
     * If true, attribute used as pass through html attribue, eg. rendered directly into html without any transformations.
     * </p>
     *
     * @return
     */
    boolean passThrough() default false;

    /**
     * <p class="changed_added_4_0">
     * Marks attribute as required. Generated tag handler should check its presence.
     * </p>
     *
     * @return
     */
    boolean required() default false;

    /**
     * <p class="changed_added_4_0">
     * Tells CDK to generate getter and setter for attribute.
     * </p>
     *
     * @return
     */
    boolean generate() default true;

    /**
     * <p class="changed_added_4_0">
     * Attribute default value. Should be valid Java code that can be used in field initialiser of function call.
     * </p>
     *
     * @return
     */
    String defaultValue() default "";

    /**
     * <p class="changed_added_4_0">
     * Used by IDE to suggest attribute value.
     * </p>
     *
     * @return
     */
    String suggestedValue() default "";

    /**
     * <p class="changed_added_4_0">
     * Attribute description to include in generated faces-config.xml and taglibs.
     * </p>
     *
     * @return
     */
    Description description() default @Description();

    /**
     * <p class="changed_added_4_0">
     * Method signature for attributes with EL method reference type, either {@link MethodBinding} or {@link MethodExpression}.
     * </p>
     *
     * @return
     */
    Signature signature() default @Signature(returnType = Signature.NONE.class);

    /**
     * <p class="changed_added_4_0">
     * Event descriptions for {@link ClientBehavior} binding.
     * </p>
     *
     * @return
     */
    EventName[] events() default {};

    /**
     * <p class="changed_added_4_0">
     * Attribute aliases.
     * </p>
     *
     * @return
     */
    Alias[] aliases() default {};
}
