/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.Path;

public class VCPVersionTask
extends Task {
    private String versionProperty = "EXADEL_VCP_VERSION";
    private String vendorProperty = "EXADEL_VCP_VENDOR";
    private File output;
    private String _versionBean;
    private Path _classpath;

    public Path getClasspath() {
        return this._classpath;
    }

    public void setClasspath(Path classpath) {
        if (null == this._classpath) {
            this._classpath = classpath;
        } else {
            this._classpath.add(classpath);
        }
    }

    public Path createClasspath() {
        Path classpath = new Path(this.getProject());
        if (null == this._classpath) {
            this._classpath = classpath;
        } else {
            this._classpath.add(classpath);
        }
        return classpath;
    }

    public void setClasspathRef(Ant.Reference ref) {
        Object refObj = ref.getReferencedObject();
        if (refObj instanceof Path) {
            this.setClasspath((Path)refObj);
        }
    }

    public String getVersionBean() {
        return this._versionBean;
    }

    public void setVersionBean(String versionBean) {
        this._versionBean = versionBean;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File outputFile) {
        this.output = outputFile;
    }

    public void execute() throws BuildException {
        String cvsLabel = null;
        try {
            AntClassLoader classLoader = this.getProject().createClassLoader(this.getClasspath());
            Class beanClass = classLoader.loadClass(this.getVersionBean());
            Object chameleonBean = beanClass.newInstance();
            String version = BeanUtils.getProperty(chameleonBean, (String)"version");
            version = version.replaceAll("\\$|(Date(.*))", "").trim();
            cvsLabel = version.replaceAll("\\W", "_");
            this.getProject().setProperty(this.getVendorProperty(), BeanUtils.getProperty(chameleonBean, (String)"vendor"));
            this.getProject().setProperty(this.getVersionProperty(), version);
            System.out.println(this.getProject().getProperty(this.getVersionProperty()));
            System.out.println(cvsLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getProject().fireBuildFinished((Throwable)e);
        }
        try {
            if (this.output.exists()) {
                this.output.delete();
            }
            FileWriter fileWriter = new FileWriter(this.output);
            fileWriter.write(cvsLabel);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getProject().fireBuildFinished((Throwable)e);
        }
    }

    public String getVendorProperty() {
        return this.vendorProperty;
    }

    public void setVendorProperty(String vendorProperty) {
        this.vendorProperty = vendorProperty;
    }

    public String getVersionProperty() {
        return this.versionProperty;
    }

    public void setVersionProperty(String versionProperty) {
        this.versionProperty = versionProperty;
    }
}

