/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.component;

import org.ajax4jsf.builder.component.PropertyProcessor;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.model.Argument;
import org.ajax4jsf.builder.model.JavaClass;
import org.ajax4jsf.builder.model.JavaComment;
import org.ajax4jsf.builder.model.JavaField;
import org.ajax4jsf.builder.model.JavaLanguageElement;
import org.ajax4jsf.builder.model.JavaMethod;
import org.ajax4jsf.builder.model.JavaModifier;
import org.ajax4jsf.builder.model.JavaPrimitive;
import org.ajax4jsf.builder.model.MethodBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPropertyProcessor
implements PropertyProcessor {
    @Override
    public boolean accept(PropertyBean propertyBean, JavaClass javaClass, JSFGeneratorConfiguration configuration) {
        return !propertyBean.isExist();
    }

    @Override
    public void process(PropertyBean propertyBean, JavaClass javaClass, JSFGeneratorConfiguration configuration) {
        JavaField field = this.getField(propertyBean, configuration);
        javaClass.addField(field);
        javaClass.addMethod(this.getAccessor(configuration, propertyBean, field));
        javaClass.addMethod(this.getMutator(configuration, propertyBean, field));
    }

    protected JavaField getField(PropertyBean propertyBean, JSFGeneratorConfiguration configuration) {
        String name = propertyBean.getName();
        String defaultvalue = propertyBean.getDefaultvalue();
        Class<?> propertyClass = this.getType(propertyBean, configuration.getClassLoader());
        JavaField field = new JavaField(propertyClass, "_" + name, defaultvalue);
        field.getComments().add(new JavaComment(propertyBean.getXmlEncodedDescription()));
        field.getModifiers().add(JavaModifier.PRIVATE);
        this.handleDeprecation(field.getType(), field);
        return field;
    }

    protected Class<?> getType(PropertyBean propertyBean, ClassLoader classLoader) {
        if (propertyBean.isSimpleType()) {
            try {
                Class<?> clazz = JavaPrimitive.forName(propertyBean.getClassname());
                return clazz;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                Class<?> clazz = Class.forName(propertyBean.getClassname(), false, classLoader);
                return clazz;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Object.class;
    }

    protected JavaMethod getAccessor(JSFGeneratorConfiguration configuration, PropertyBean propertyBean, final JavaField field) {
        JavaMethod accessor = new JavaMethod(propertyBean.getGetterName(), field.getType(), new Argument[0]);
        accessor.setMethodBody(new MethodBody(){

            public String toCode() {
                return "return " + field.getName() + ";";
            }
        });
        accessor.addModifier(JavaModifier.PUBLIC);
        this.handleDeprecation(field.getType(), accessor);
        return accessor;
    }

    protected JavaMethod getMutator(JSFGeneratorConfiguration configuration, PropertyBean propertyBean, final JavaField field) {
        JavaMethod mutator = new JavaMethod(propertyBean.getSetterName(), new Argument(field.getName(), field.getType()));
        mutator.setMethodBody(new MethodBody(mutator){

            public String toCode() {
                return "this." + field.getName() + " = " + field.getName() + ";";
            }
        });
        this.handleDeprecation(field.getType(), mutator);
        mutator.addModifier(JavaModifier.PUBLIC);
        return mutator;
    }

    protected void handleDeprecation(Class<?> type, JavaLanguageElement element) {
        if (type.isAnnotationPresent(Deprecated.class)) {
            element.addAnnotation(SuppressWarnings.class, "\"deprecation\"");
        }
    }
}

