/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.config;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ajax4jsf.builder.config.ComponentBaseBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionBean
extends ComponentBaseBean {
    private String method;
    private String signature;
    private static final Pattern SIGNATURE = Pattern.compile("\\s*((?:\\[\\s*\\]\\s*)*)(\\.\\.\\.)?\\s*$");

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    private static final int getArrayDepth(Class<?> clazz) {
        if (clazz.isArray()) {
            return FunctionBean.getArrayDepth(clazz.getComponentType()) + 1;
        }
        return 0;
    }

    private static final int getArrayDepth(String signature) {
        Matcher matcher = SIGNATURE.matcher(signature);
        if (matcher.find()) {
            int depth = 0;
            int groupCount = matcher.groupCount();
            for (int i = 1; i <= groupCount; ++i) {
                String string = matcher.group(i);
                if (string == null) continue;
                String group = matcher.group(i).trim();
                if ("...".equals(group)) {
                    ++depth;
                    continue;
                }
                int l = group.length();
                for (int j = 0; j < l; ++j) {
                    if (group.charAt(j) != '[') continue;
                    ++depth;
                }
            }
            return depth;
        }
        return 0;
    }

    private static final Class<?> getComponentType(Class<?> clazz) {
        if (clazz.isArray()) {
            return FunctionBean.getComponentType(clazz.getComponentType());
        }
        return clazz;
    }

    private static final String getComponentType(String signature) {
        return SIGNATURE.matcher(signature).replaceFirst("");
    }

    private void findMethod() {
        Method[] methods;
        Class<?> clazz;
        int k;
        if (this.method == null || this.method.length() == 0) {
            throw new IllegalArgumentException("Method " + this.getName() + " is null or empty!");
        }
        int i = this.method.indexOf(40);
        if (i == -1 || this.method.charAt(this.method.length() - 1) != ')') {
            throw new IllegalArgumentException("Method " + this.method + ": brace(s) are missing!");
        }
        String fqMethodName = this.method.substring(0, i);
        String signature = this.method.substring(i + 1, this.method.length() - 1);
        int j = fqMethodName.lastIndexOf(46);
        int sepIdx = Math.max(j, k = fqMethodName.lastIndexOf(35));
        if (sepIdx == -1) {
            throw new IllegalArgumentException("Method: " + this.method + ": doesn't have '.' or '#' method name separator char!");
        }
        String classname = fqMethodName.substring(0, sepIdx);
        try {
            clazz = this.getLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
        this.setClassname(classname);
        String methodName = fqMethodName.substring(sepIdx + 1);
        String[] parameters = signature.split("\\s*,\\s*");
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameters.length != parameterTypes.length) continue;
            StringBuilder signatureBuilder = new StringBuilder();
            signatureBuilder.append('(');
            boolean matches = true;
            for (int l = 0; l < parameterTypes.length; ++l) {
                String parameter = parameters[l];
                int depth = FunctionBean.getArrayDepth(parameter);
                String componentType = FunctionBean.getComponentType(parameter);
                Class<?> type = FunctionBean.getComponentType(parameterTypes[l]);
                int arrayDepth = FunctionBean.getArrayDepth(parameterTypes[l]);
                if (depth != arrayDepth || !componentType.equals(type.getSimpleName()) && !componentType.equals(type.getName())) {
                    matches = false;
                    break;
                }
                signatureBuilder.append(parameterTypes[l].getCanonicalName());
                if (l != parameterTypes.length - 1) {
                    signatureBuilder.append(", ");
                    continue;
                }
                signatureBuilder.append(')');
            }
            if (!matches) continue;
            this.signature = method.getReturnType().getCanonicalName() + " " + methodName + signatureBuilder.toString();
            break;
        }
        if (this.signature == null) {
            throw new IllegalStateException("Method: " + this.method + " not found!");
        }
    }

    public String getMethodClassname() {
        if (this.getClassname() == null) {
            this.findMethod();
        }
        return this.getClassname();
    }

    public String getMethodSignature() {
        if (this.signature == null) {
            this.findMethod();
        }
        return this.signature;
    }
}

