/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.ConverterBean;
import org.ajax4jsf.builder.config.FunctionBean;
import org.ajax4jsf.builder.config.ListenerBean;
import org.ajax4jsf.builder.config.ValidatorBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.XMLConfigGenerator;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class FaceletsTaglibGenerator
extends XMLConfigGenerator {
    private static final String FACELETS_TAGLIB_TEMPLATE_NAME = "facelets.taglib.vm";
    private File _taglib = null;
    private String _uri = null;
    private String _shortname = null;
    private String _description = null;
    private String _displayName = null;

    public FaceletsTaglibGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        Template template = this.getTemplate();
        ArrayList<ComponentBean> components = new ArrayList<ComponentBean>();
        for (ComponentBean component : config.getComponents()) {
            boolean includeComponent = true;
            if (component.getTag() == null && component.getTaghandler() == null) continue;
            includeComponent = this.isIncludeComponent(component);
            if (includeComponent) {
                this.info("Component " + component.getName() + " included to taglib " + this.getShortname());
                components.add(component);
                continue;
            }
            this.info("Component " + component.getName() + " excluded from taglib " + this.getShortname());
        }
        ArrayList<ValidatorBean> validators = new ArrayList<ValidatorBean>();
        for (ValidatorBean validator : config.getValidators()) {
            boolean includeValidator = true;
            if (validator.getTag() == null && validator.getTaghandler() == null) continue;
            includeValidator = this.isIncludeComponent(validator);
            if (includeValidator) {
                this.info("Validator " + validator.getName() + " included to taglib " + this.getShortname());
                validators.add(validator);
                continue;
            }
            this.info("Validator " + validator.getName() + " excluded from taglib " + this.getShortname());
        }
        ArrayList<ConverterBean> converters = new ArrayList<ConverterBean>();
        for (ConverterBean converter : config.getConverters()) {
            boolean includeConverter = true;
            if (converter.getTag() == null && converter.getTaghandler() == null) continue;
            includeConverter = this.isIncludeComponent(converter);
            if (includeConverter) {
                this.info("Converter " + converter.getName() + " included to taglib " + this.getShortname());
                converters.add(converter);
                continue;
            }
            this.info("Converter " + converter.getName() + " excluded from taglib " + this.getShortname());
        }
        ArrayList<ListenerBean> listeners = new ArrayList<ListenerBean>();
        block5: for (ListenerBean bean : config.getListeners()) {
            for (ComponentBean componentBean : bean.getSuitableComponents()) {
                if (!components.contains(componentBean) || bean.getTaghandler() == null) continue;
                listeners.add(bean);
                continue block5;
            }
        }
        ArrayList<FunctionBean> functions = new ArrayList<FunctionBean>();
        for (FunctionBean functionBean : config.getFunctions()) {
            if (this.isIncludeComponent(functionBean)) {
                this.info("Function " + functionBean.getName() + " included in taglib " + this.getShortname());
                functions.add(functionBean);
                continue;
            }
            this.info("Function " + functionBean.getName() + " excluded from taglib " + this.getShortname());
        }
        if (components.size() > 0 || validators.size() > 0 || converters.size() > 0 || functions.size() > 0) {
            if (listeners.size() > 0) {
                context.put("listeners", listeners);
            }
            if (components.size() > 0) {
                context.put("components", components);
            }
            if (validators.size() > 0) {
                context.put("validators", validators);
            }
            if (converters.size() > 0) {
                context.put("converters", converters);
            }
            if (functions.size() > 0) {
                context.put("functions", functions);
            }
            context.put("taglib", (Object)this);
            File taglibFile = this.getTaglib();
            File javaDir = taglibFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (taglibFile.exists()) {
                    taglibFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(taglibFile));
                template.merge((Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create new taglib file ", e);
            }
        }
    }

    protected String getDefaultTemplateName() {
        return FACELETS_TAGLIB_TEMPLATE_NAME;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getShortname() {
        return this._shortname;
    }

    public void setShortname(String shortName) {
        this._shortname = shortName;
    }

    public File getTaglib() {
        return this._taglib;
    }

    public void setTaglib(File taglib) {
        this._taglib = taglib;
    }

    public String getUri() {
        return this._uri;
    }

    public void setUri(String uri) {
        this._uri = uri;
    }

    protected String getRootTag() {
        return "facelet-taglib";
    }
}

