/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBaseBean;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.RendererBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.RendererCompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.builder.TemplateCompiler;

public class RendererGenerator
extends InnerGenerator {
    private static final String RENDERER_TEMPLATE_NAME = "renderer.vm";
    private File _srcDir = null;
    private String _package = null;

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String package1) {
        this._package = package1;
    }

    public File getSrcDir() {
        return this._srcDir;
    }

    public void setSrcDir(File srcDir) {
        this._srcDir = srcDir;
    }

    public RendererGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        for (ComponentBean component : config.getComponents()) {
            RendererBean renderer = component.getRenderer();
            this.createRenderer(renderer, component);
        }
        for (RendererBean renderer : config.getRenderers()) {
            this.createRenderer(renderer, null);
        }
    }

    public void createRenderer(RendererBean renderer, ComponentBaseBean component) throws GeneratorException {
        if (null != renderer && renderer.isGenerate() && null != renderer.getTemplate()) {
            try {
                RendererCompilationContext rendererBean;
                File template;
                block12: {
                    template = null != this.getSrcDir() ? new File(this.getSrcDir(), renderer.getTemplate()) : new File(renderer.getTemplate());
                    rendererBean = new RendererCompilationContext(this.getLog(), this.getClassLoader(), this.getConfig());
                    if (null != renderer.getClassname()) {
                        rendererBean.setBaseclass(renderer.getClassname());
                    }
                    if (null != renderer.getClassname()) {
                        rendererBean.setFullClassName(renderer.getClassname());
                    }
                    if (null != component) {
                        try {
                            rendererBean.setComponentClass(component.getClassname());
                        }
                        catch (CompilationException e) {
                            if (null == component.getSuperclass()) break block12;
                            rendererBean.setComponentClass(component.getSuperclass());
                        }
                    }
                }
                TemplateCompiler templateCompiler = new TemplateCompiler();
                FileInputStream templateStream = new FileInputStream(template);
                templateCompiler.processing(templateStream, rendererBean);
                renderer.setClassname(rendererBean.getFullClassName());
                String resultPath = rendererBean.getComponentFileName();
                resultPath = null == this.getPackage() ? resultPath.replace('.', '/') : this.getPackage().replace('.', '/') + "/" + resultPath;
                File javaFile = new File(this.getDestDir(), resultPath + ".java");
                File javaDir = javaFile.getParentFile();
                if (!javaDir.exists()) {
                    javaDir.mkdirs();
                }
                if (javaFile.exists()) {
                    if (renderer.isOverride()) {
                        javaFile.delete();
                    } else {
                        return;
                    }
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
                templateCompiler.generateCode(rendererBean, out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create Renderer Java file ", e);
            }
        }
    }

    protected String getDefaultTemplateName() {
        return RENDERER_TEMPLATE_NAME;
    }
}

