/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.el;

import com.sun.el.parser.ArithmeticNode;
import com.sun.el.parser.AstAnd;
import com.sun.el.parser.AstBracketSuffix;
import com.sun.el.parser.AstChoice;
import com.sun.el.parser.AstDeferredExpression;
import com.sun.el.parser.AstDiv;
import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.AstEmpty;
import com.sun.el.parser.AstEqual;
import com.sun.el.parser.AstFalse;
import com.sun.el.parser.AstFunction;
import com.sun.el.parser.AstGreaterThan;
import com.sun.el.parser.AstGreaterThanEqual;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstInteger;
import com.sun.el.parser.AstLessThan;
import com.sun.el.parser.AstLessThanEqual;
import com.sun.el.parser.AstLiteralExpression;
import com.sun.el.parser.AstMinus;
import com.sun.el.parser.AstMod;
import com.sun.el.parser.AstMult;
import com.sun.el.parser.AstNot;
import com.sun.el.parser.AstNotEqual;
import com.sun.el.parser.AstOr;
import com.sun.el.parser.AstPlus;
import com.sun.el.parser.AstString;
import com.sun.el.parser.AstTrue;
import com.sun.el.parser.AstValue;
import com.sun.el.parser.BooleanNode;
import com.sun.el.parser.ELParser;
import com.sun.el.parser.Node;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.StringUtils;
import org.ajax4jsf.templatecompiler.el.IELCompiler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELCompiler
implements IELCompiler {
    private static final Log log = LogFactory.getLog(ELCompiler.class);
    Map<String, String> functionsMap = new HashMap<String, String>();

    public ELCompiler() {
        this.resetVariables();
    }

    public void resetVariables() {
        this.functionsMap.put("a4jSkin:getParameter", "org.ajax4jsf.framework.skin.getParameter");
    }

    @Override
    public String compileEL(String expression, CompilationContext componentBean) {
        Node node = ELParser.parse((String)expression);
        StringBuffer sbMain = new StringBuffer();
        this.processNode(node, sbMain, componentBean);
        return sbMain.toString();
    }

    private void processNode(Node node, StringBuffer sbMain, CompilationContext componentBean) {
        Node childNode;
        int i;
        int numChildren = node.jjtGetNumChildren();
        boolean bNeedConversion = false;
        for (i = 0; i < numChildren; ++i) {
            childNode = node.jjtGetChild(i);
            if (!(childNode instanceof AstLiteralExpression)) continue;
            bNeedConversion = true;
            break;
        }
        for (i = 0; i < numChildren; ++i) {
            boolean processing;
            childNode = node.jjtGetChild(i);
            if (childNode instanceof AstLiteralExpression) {
                if (childNode.getImage() == null) continue;
                if (i > 0) {
                    sbMain.append(" + ");
                }
                sbMain.append("\"");
                sbMain.append(StringUtils.getEscapedString(childNode.getImage()));
                sbMain.append("\"");
                if (i >= numChildren - 1) continue;
                sbMain.append(" + ");
                continue;
            }
            if (bNeedConversion) {
                sbMain.append("convertToString(");
            }
            if (!(processing = this.processingNode(childNode, sbMain, componentBean))) {
                this.processNode(childNode, sbMain, componentBean);
            }
            if (!bNeedConversion) continue;
            sbMain.append(")");
        }
    }

    public boolean processingNode(Node node, StringBuffer sbMain, CompilationContext componentBean) {
        boolean returnValue = false;
        if (node instanceof ArithmeticNode) {
            returnValue = this.processingArithmeticNode((ArithmeticNode)node, sbMain, componentBean);
        } else if (node instanceof AstIdentifier) {
            returnValue = this.processingIdentifier((AstIdentifier)node, sbMain, componentBean);
        } else if (node instanceof AstValue) {
            returnValue = this.processingValue((AstValue)node, sbMain, componentBean);
        } else if (node instanceof AstInteger) {
            returnValue = this.processingInteger((AstInteger)node, sbMain);
        } else if (node instanceof AstString) {
            returnValue = this.processingString((AstString)node, sbMain);
        } else if (node instanceof AstFunction) {
            returnValue = this.processingFunction((AstFunction)node, sbMain, componentBean);
        } else if (!(node instanceof AstDeferredExpression)) {
            if (node instanceof BooleanNode) {
                returnValue = this.processingBooleanNode((BooleanNode)node, sbMain, componentBean);
            } else if (node instanceof AstNot) {
                returnValue = this.processingNot((AstNot)node, sbMain, componentBean);
            } else if (node instanceof AstChoice) {
                returnValue = this.processingChoice((AstChoice)node, sbMain, componentBean);
            } else if (node instanceof AstEmpty) {
                returnValue = this.processingEmpty((AstEmpty)node, sbMain, componentBean);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(node.toString());
                sb.append(" (");
                sb.append(node.getClass().getName());
                sb.append(")");
                log.debug((Object)sb.toString());
            }
        }
        return returnValue;
    }

    private boolean processingEmpty(AstEmpty node, StringBuffer sbMain, CompilationContext componentBean) {
        boolean returnValue = false;
        StringBuffer sb1 = new StringBuffer();
        Node node1 = node.jjtGetChild(0);
        if (null != node1 && !(returnValue = this.processingNode(node1, sb1, componentBean))) {
            log.error((Object)("Error processing node1: " + node1.getImage()));
        }
        if (returnValue) {
            sbMain.append(" isEmpty( ");
            sbMain.append(sb1);
            sbMain.append(" ) ");
        }
        return returnValue;
    }

    private boolean processingChoice(AstChoice node, StringBuffer sbMain, CompilationContext componentBean) {
        Node node3;
        Node node2;
        boolean returnValue = true;
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb3 = new StringBuffer();
        Node node1 = node.jjtGetChild(0);
        if (node1 != null && !(returnValue &= this.processingNode(node1, sb1, componentBean))) {
            log.error((Object)("Error processing node1: " + node1.getImage()));
        }
        if (null != (node2 = node.jjtGetChild(1)) && !(returnValue &= this.processingNode(node2, sb2, componentBean))) {
            log.error((Object)("Error processing node2: " + node2.getImage()));
        }
        if (null != (node3 = node.jjtGetChild(2)) && !(returnValue &= this.processingNode(node3, sb3, componentBean))) {
            log.error((Object)("Error processing node3: " + node3.getImage()));
        }
        if (returnValue) {
            sbMain.append(" ( ");
            sbMain.append(sb1);
            sbMain.append(" ? ");
            sbMain.append(sb2);
            sbMain.append(" : ");
            sbMain.append(sb3);
            sbMain.append(" ) ");
        }
        return returnValue;
    }

    private boolean processingNot(AstNot node, StringBuffer sbMain, CompilationContext componentBean) {
        boolean returnValue = false;
        StringBuffer sb1 = new StringBuffer();
        Node node1 = node.jjtGetChild(0);
        if (null != node1 && !(returnValue = this.processingNode(node1, sb1, componentBean))) {
            log.error((Object)("Error processing node1: " + node1.getImage()));
        }
        if (returnValue) {
            sbMain.append(" ( ! ");
            sbMain.append(sb1);
            sbMain.append(" ) ");
        }
        return returnValue;
    }

    private boolean processingBooleanNode(BooleanNode node, StringBuffer sb, CompilationContext componentBean) {
        Node node2;
        boolean returnValue = true;
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        if (node instanceof AstFalse) {
            sb.append(" false ");
            return returnValue;
        }
        if (node instanceof AstTrue) {
            sb.append(" true ");
            return returnValue;
        }
        Node node1 = node.jjtGetChild(0);
        if (node1 != null && !(returnValue &= this.processingNode(node1, sb1, componentBean))) {
            log.error((Object)("Error processing node1: " + node1.getImage()));
        }
        if (null != (node2 = node.jjtGetChild(1)) && !(returnValue &= this.processingNode(node2, sb2, componentBean))) {
            log.error((Object)("Error processing node2: " + node2.getImage()));
        }
        if (returnValue) {
            sb.append(" ( ");
            sb.append(sb1);
            if (node instanceof AstAnd) {
                sb.append(" && ");
            } else if (node instanceof AstEqual) {
                sb.append(" == ");
            } else if (node instanceof AstGreaterThan) {
                sb.append(" > ");
            } else if (node instanceof AstGreaterThanEqual) {
                sb.append(" >= ");
            } else if (node instanceof AstLessThan) {
                sb.append(" < ");
            } else if (node instanceof AstLessThanEqual) {
                sb.append(" <= ");
            } else if (node instanceof AstNotEqual) {
                sb.append(" != ");
            } else if (node instanceof AstOr) {
                sb.append(" || ");
            }
            sb.append(sb2);
            sb.append(" ) ");
        }
        return returnValue;
    }

    private boolean processingArithmeticNode(ArithmeticNode node, StringBuffer sb, CompilationContext componentBean) {
        Node node2;
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        boolean returnValue = true;
        Node node1 = node.jjtGetChild(0);
        if (node1 != null && !(returnValue &= this.processingNode(node1, sb1, componentBean))) {
            log.error((Object)("Error processing node1: " + node1.getImage()));
        }
        if (null != (node2 = node.jjtGetChild(1)) && !(returnValue &= this.processingNode(node2, sb2, componentBean))) {
            log.error((Object)("Error processing node2: " + node2.getImage()));
        }
        if (returnValue) {
            sb.append(" ( ");
            sb.append(sb1);
            if (node instanceof AstDiv) {
                sb.append(" / ");
            } else if (node instanceof AstMult) {
                sb.append(" * ");
            } else if (node instanceof AstMod) {
                sb.append(" % ");
            } else if (node instanceof AstPlus) {
                sb.append(" + ");
            } else if (node instanceof AstMinus) {
                sb.append(" - ");
            }
            sb.append(sb2);
            sb.append(" ) ");
        }
        return returnValue;
    }

    private boolean processingInteger(AstInteger node, StringBuffer sb) {
        sb.append(node.getImage());
        return true;
    }

    private boolean processingString(AstString node, StringBuffer sb) {
        sb.append("\"");
        sb.append(node.getString());
        sb.append("\"");
        return true;
    }

    private boolean processingFunction(AstFunction node, StringBuffer sb, CompilationContext componentBean) {
        log.debug((Object)("Processing function : " + node.getPrefix()));
        log.debug((Object)("Processing function : " + node.getLocalName()));
        log.debug((Object)("Processing function : " + node.getOutputName()));
        if (node.getPrefix().equals("this")) {
            sb.append(node.getLocalName());
            sb.append("(");
            int numChildren = node.jjtGetNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                Node childNode = node.jjtGetChild(i);
                StringBuffer buf = new StringBuffer();
                this.processingNode(childNode, buf, componentBean);
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(buf);
            }
            sb.append(")");
        } else {
            String functionName = node.getOutputName();
            if (this.functionsMap.containsKey(functionName)) {
                sb.append(this.functionsMap.get(functionName));
                sb.append("(");
                int numChildren = node.jjtGetNumChildren();
                for (int i = 0; i < numChildren; ++i) {
                    Node childNode = node.jjtGetChild(i);
                    StringBuffer buf = new StringBuffer();
                    this.processingNode(childNode, buf, componentBean);
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(buf);
                }
                sb.append(")");
            }
        }
        return true;
    }

    private boolean processingIdentifier(AstIdentifier node, StringBuffer sb, CompilationContext componentBean) {
        String variableName = node.getImage();
        if (componentBean.containsVariable(variableName)) {
            sb.append(variableName);
        } else {
            sb.append("variables.getVariable(\"");
            sb.append(variableName);
            sb.append("\")");
        }
        return true;
    }

    private String processingBracketSuffix(AstBracketSuffix basketSuffix, CompilationContext componentBean) {
        StringBuffer sb = new StringBuffer();
        Node node = basketSuffix.jjtGetChild(0);
        if (node instanceof AstIdentifier) {
            this.processingIdentifier((AstIdentifier)node, sb, componentBean);
        } else if (node instanceof AstInteger) {
            sb.append(node.getImage());
        } else if (node instanceof AstString) {
            AstString stringNode = (AstString)node;
            sb.append("\"");
            sb.append(stringNode.getString());
            sb.append("\"");
        } else {
            sb.append("\"");
            sb.append(node.getImage());
            sb.append("\"");
        }
        return sb.toString();
    }

    private PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName, CompilationContext compilationContext) {
        return compilationContext.getPropertyDescriptor(clazz, propertyName);
    }

    private boolean processingValue(AstValue node, StringBuffer sb, CompilationContext componentBean) {
        String lastIndexValue = "null";
        String lastVariableType = null;
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            StringBuffer sb1 = new StringBuffer();
            Node subChild = node.jjtGetChild(i);
            if (subChild instanceof AstIdentifier) {
                String variableName = subChild.getImage();
                if (componentBean.containsVariable(variableName)) {
                    lastVariableType = componentBean.getVariableType(variableName).getName();
                    names.add(variableName);
                    continue;
                }
                this.processingIdentifier((AstIdentifier)subChild, sb1, componentBean);
                continue;
            }
            if (subChild instanceof AstDotSuffix) {
                String propertyName = subChild.getImage();
                log.debug((Object)("Object: " + lastVariableType + ", property: " + propertyName));
                if (lastVariableType != null) {
                    try {
                        Class<?> clazz = componentBean.loadClass(lastVariableType);
                        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(clazz, propertyName, componentBean);
                        if (propertyDescriptor == null) {
                            throw new PropertyNotFoundException("property: " + propertyName + " not found in class: " + lastVariableType);
                        }
                        log.debug((Object)("propertyObject: " + propertyDescriptor.getPropertyType().getName()));
                        StringBuffer tmpbuf = new StringBuffer();
                        tmpbuf.append(propertyDescriptor.getReadMethod().getName());
                        tmpbuf.append("()");
                        names.add(tmpbuf.toString());
                        lastVariableType = propertyDescriptor.getPropertyType().getName();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                sb1.append("getProperty(");
                sb1.append(lastIndexValue);
                sb1.append(",");
                sb1.append("\"");
                sb1.append(subChild.getImage());
                sb1.append("\")");
                continue;
            }
            if (!(subChild instanceof AstBracketSuffix)) continue;
            String bracketSuffix = this.processingBracketSuffix((AstBracketSuffix)subChild, componentBean);
            if (lastVariableType != null) {
                StringBuffer tmpbuf = new StringBuffer();
                if (lastVariableType.startsWith("[L")) {
                    tmpbuf.append("[");
                    tmpbuf.append(bracketSuffix);
                    tmpbuf.append("]");
                    names.add(tmpbuf.toString());
                }
                if (lastVariableType.compareTo("java.util.List") != 0 && lastVariableType.compareTo("java.util.Map") != 0) continue;
                tmpbuf.append("get(");
                tmpbuf.append(bracketSuffix);
                tmpbuf.append(")");
                names.add(tmpbuf.toString());
                continue;
            }
            sb1.append("getElelmentByIndex(");
            sb1.append(lastIndexValue);
            sb1.append(",");
            sb1.append(bracketSuffix);
            sb1.append(")");
        }
        if (names.size() != 0) {
            StringBuffer tmpbuf = new StringBuffer();
            for (String element : names) {
                if (tmpbuf.length() != 0) {
                    tmpbuf.append(".");
                }
                tmpbuf.append(element);
            }
            sb.append(tmpbuf.toString());
        } else {
            sb.append(lastIndexValue);
        }
        return true;
    }
}

