/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.elements.ElementsFactory;
import org.ajax4jsf.templatecompiler.elements.RootElement;
import org.ajax4jsf.templatecompiler.elements.TemplateElement;
import org.ajax4jsf.templatecompiler.elements.html.CDATAElement;
import org.ajax4jsf.templatecompiler.elements.html.CommentElement;
import org.ajax4jsf.templatecompiler.elements.html.PIElement;
import org.ajax4jsf.templatecompiler.elements.html.TextElement;
import org.ajax4jsf.templatecompiler.elements.vcp.AjaxRenderedAreaElement;
import org.ajax4jsf.templatecompiler.elements.vcp.HeaderScriptsElement;
import org.ajax4jsf.templatecompiler.elements.vcp.HeaderStylesElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class A4JRendererElementsFactory
implements ElementsFactory {
    private static final Log log = LogFactory.getLog(A4JRendererElementsFactory.class);
    public static final String TEMPLATES_PATH = "META-INF/templates";
    public static final String TEMPLATES_TEMPLATECOMPILER_PATH = "META-INF/templates/templatecompiler";
    private static final String DEFAULT_CLASS_ELEMENT_PROCESSOR = "org.ajax4jsf.templatecompiler.elements.html.HTMLElement";
    private static final Class[] paramClasses = new Class[]{Node.class, CompilationContext.class};
    private static final HashMap<String, String> mapClasses = new HashMap();

    public TemplateElement getProcessor(Node nodeElement, CompilationContext componentBean) throws CompilationException {
        TemplateElement returnValue = null;
        short nodeType = nodeElement.getNodeType();
        if (4 == nodeType) {
            returnValue = new CDATAElement(nodeElement, componentBean);
        } else if (3 == nodeType) {
            returnValue = new TextElement(nodeElement, componentBean);
        } else if (8 == nodeType) {
            returnValue = new CommentElement(nodeElement, componentBean);
        } else if (7 == nodeType) {
            returnValue = new PIElement(nodeElement, componentBean);
        } else if (1 == nodeType) {
            String className = mapClasses.get(nodeElement.getNodeName());
            if (className == null) {
                className = DEFAULT_CLASS_ELEMENT_PROCESSOR;
            }
            if (!className.equals("")) {
                try {
                    log.debug((Object)("loading class: " + className));
                    Class<?> class1 = Class.forName(className);
                    Object[] objects = new Object[]{nodeElement, componentBean};
                    returnValue = (TemplateElement)class1.getConstructor(paramClasses).newInstance(objects);
                }
                catch (InstantiationException e) {
                    throw new CompilationException("InstantiationException: " + e.getLocalizedMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new CompilationException("IllegalAccessException: " + e.getLocalizedMessage(), e);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new CompilationException("InvocationTargetException: " + e.getMessage(), e);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    throw new CompilationException(" error loading class: " + e.getLocalizedMessage());
                }
            }
        }
        return returnValue;
    }

    static {
        mapClasses.put("c:set", "org.ajax4jsf.templatecompiler.elements.std.SetTemplateElement");
        mapClasses.put("c:object", "org.ajax4jsf.templatecompiler.elements.std.ObjectTemplateElement");
        mapClasses.put("c:if", "org.ajax4jsf.templatecompiler.elements.std.IFTemplateElement");
        mapClasses.put("c:forEach", "org.ajax4jsf.templatecompiler.elements.std.ForEachTemplateElement");
        mapClasses.put("f:clientid", "org.ajax4jsf.templatecompiler.elements.vcp.FClientIDTemplateElement");
        mapClasses.put("f:clientId", "org.ajax4jsf.templatecompiler.elements.vcp.FClientIDTemplateElement");
        mapClasses.put("f:insertComponent", "org.ajax4jsf.templatecompiler.elements.vcp.InsertComponent");
        mapClasses.put("f:call", "org.ajax4jsf.templatecompiler.elements.vcp.FCallTemplateElement");
        mapClasses.put("f:resource", "org.ajax4jsf.templatecompiler.elements.vcp.FResourceTemplateElement");
        mapClasses.put("u:insertFacet", "org.ajax4jsf.templatecompiler.elements.vcp.UInsertFacetTemplateElement");
        mapClasses.put("vcp:body", "org.ajax4jsf.templatecompiler.elements.vcp.VcpBodyTemplateElement");
        mapClasses.put("vcp:mock", "");
        mapClasses.put("jsp:scriptlet", "org.ajax4jsf.templatecompiler.elements.jsp.Scriptlet");
        mapClasses.put("jsp:declaration", "org.ajax4jsf.templatecompiler.elements.jsp.Declaration");
        mapClasses.put("jsp:directive.page", "org.ajax4jsf.templatecompiler.elements.jsp.DirectivePage");
        mapClasses.put("jsp:expression", "org.ajax4jsf.templatecompiler.elements.jsp.Expression");
        mapClasses.put("h:styles", HeaderStylesElement.class.getName());
        mapClasses.put("h:scripts", HeaderScriptsElement.class.getName());
        mapClasses.put("f:template", RootElement.class.getName());
        mapClasses.put("f:root", RootElement.class.getName());
        mapClasses.put("jsp:root", RootElement.class.getName());
        mapClasses.put("ajax:update", AjaxRenderedAreaElement.class.getName());
    }
}

