/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ajax4jsf.templatecompiler.ant.AntCompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.builder.TemplateCompiler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class TemplateCompilerTask
extends Task
implements FilenameFilter {
    private static final String regexComponent = "^(.*)\\.xhtml$";
    private static final Pattern patternComponent = Pattern.compile("^(.*)\\.xhtml$");
    private static final String TEMPLATE_FILE_EXT = ".xhtml";
    private Path classPath;
    private File srcDir;
    private File destDir;
    protected Vector filesets = new Vector();
    private static final String VELOCITY_PROPERTIES = "velocity.properties";
    private VelocityEngine engine;
    private Map<String, Template> _templates = new HashMap<String, Template>();

    public File getSrcdir() {
        return this.srcDir;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public String generateJavaClassName(String fileTemplateName) {
        String strJavaClassName = "Unknown";
        Matcher mather = patternComponent.matcher(fileTemplateName);
        if (mather.find()) {
            strJavaClassName = mather.group(1);
        }
        return strJavaClassName;
    }

    public void processTemplate(String sFileTemplate) {
        ClassLoader loader = this.getClassLoader();
        try {
            AntCompilationContext componentBean = new AntCompilationContext(this, loader);
            TemplateCompiler templateCompiler = new TemplateCompiler();
            FileInputStream inputStream = null;
            File inputFile = new File(sFileTemplate);
            String sF = inputFile.getName().toString();
            componentBean.setFullClassName(this.generateJavaClassName(sF));
            inputStream = new FileInputStream(inputFile);
            templateCompiler.processing(inputStream, componentBean);
            String resultPath = componentBean.getComponentFileName() + ".java";
            File javaFile = new File(this.getDestdir(), resultPath);
            File javaDir = javaFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            if (javaFile.exists()) {
                javaFile.delete();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
            templateCompiler.generateCode(componentBean, out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("Error create new Component Java file, message " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public ClassLoader getClassLoader() {
        Object loader = this.getProject().createClassLoader(this.classPath);
        if (null == loader) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void init() throws BuildException {
        super.init();
        Properties velocityProperties = new Properties();
        try {
            InputStream streamVelosityProperties = TemplateCompilerTask.class.getResourceAsStream(VELOCITY_PROPERTIES);
            velocityProperties.load(streamVelosityProperties);
            this.engine = new VelocityEngine();
            this.engine.init(velocityProperties);
        }
        catch (Exception e) {
            throw new BuildException("Error init velocity engine", (Throwable)e);
        }
    }

    public void execute() throws BuildException {
        ArrayList<String> arrayFiles = new ArrayList<String>();
        if (this.getSrcdir() != null) {
            String directory = this.getSrcdir().toString();
            String[] files = new File(directory).list(this);
            for (int i = 0; i < files.length; ++i) {
                arrayFiles.add(directory + File.separatorChar + files[i]);
            }
        }
        if (this.filesets.size() == 1) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = null;
                try {
                    ds = fs.getDirectoryScanner(this.getProject());
                }
                catch (BuildException e) {
                    if (!e.getMessage().endsWith(" not found.")) {
                        throw e;
                    }
                    this.log("Warning: " + e.getMessage());
                    continue;
                }
                File fromDir = fs.getDir(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
                for (int j = 0; j < srcFiles.length; ++j) {
                    String tempFile = fromDir.getAbsolutePath().toString() + File.separator + srcFiles[j];
                    arrayFiles.add(tempFile);
                }
            }
        }
        if (arrayFiles.size() == 0) {
            this.log("Empty list");
        } else {
            for (String file : arrayFiles) {
                this.log("Processing file :'" + file + "'");
                this.processTemplate(file);
            }
        }
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(TEMPLATE_FILE_EXT);
    }

    public Path getClasspath() {
        return this.classPath;
    }

    public void setClasspath(Path classpath) {
        if (null == this.classPath) {
            this.classPath = classpath;
        } else {
            this.classPath.add(classpath);
        }
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public Path createClasspath() {
        Path classpath = new Path(this.getProject());
        if (null == this.classPath) {
            this.classPath = classpath;
        } else {
            this.classPath.add(classpath);
        }
        return classpath;
    }

    public Template getTemplate(String name) throws CompilationException {
        Template template = this._templates.get(name);
        if (null == template) {
            try {
                template = this.engine.getTemplate(name);
            }
            catch (ResourceNotFoundException e) {
                throw new CompilationException(e.getLocalizedMessage());
            }
            catch (ParseErrorException e) {
                throw new CompilationException(e.getLocalizedMessage());
            }
            catch (Exception e) {
                throw new CompilationException(e.getLocalizedMessage());
            }
            this._templates.put(name, template);
        }
        return template;
    }
}

