/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.component;

import java.util.Arrays;
import java.util.List;
import javax.faces.component.ActionSource2;
import javax.faces.el.MethodBinding;
import org.ajax4jsf.builder.component.ComponentPropertyProcessor;
import org.ajax4jsf.builder.component.methods.VelocityMethodBody;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.model.JavaClass;
import org.ajax4jsf.builder.model.JavaField;
import org.ajax4jsf.builder.model.JavaLanguageElement;
import org.ajax4jsf.builder.model.JavaMethod;

public class ActionSource2PropertyProcessor
extends ComponentPropertyProcessor {
    private static final List<String> ACCEPTED_NAMES = Arrays.asList("action", "actionListener", "actionExpression");

    public boolean accept(PropertyBean propertyBean, JavaClass javaClass, JSFGeneratorConfiguration configuration) {
        boolean result;
        boolean bl = result = !propertyBean.isExist();
        if (result && (result = ActionSource2.class.isAssignableFrom(javaClass.getSuperClass()))) {
            result = ACCEPTED_NAMES.contains(propertyBean.getName());
        }
        return result;
    }

    public void process(PropertyBean propertyBean, JavaClass javaClass, JSFGeneratorConfiguration configuration) {
        JavaField field = this.getField(propertyBean, configuration);
        JavaMethod accessor = this.getAccessor(configuration, propertyBean, field);
        JavaMethod mutator = this.getMutator(configuration, propertyBean, field);
        if ("action".equals(propertyBean.getName())) {
            try {
                accessor.setMethodBody(new VelocityMethodBody(configuration){

                    public String getTemplate() {
                        return "snippets/get-action.vm";
                    }
                });
                mutator.setMethodBody(new VelocityMethodBody(configuration){

                    public String getTemplate() {
                        return "snippets/set-action.vm";
                    }
                });
            }
            catch (GeneratorException e) {
                e.printStackTrace();
            }
        } else {
            javaClass.addField(field);
        }
        if (field.getType().getName().equals(MethodBinding.class.getName())) {
            for (JavaLanguageElement el : new JavaLanguageElement[]{field, accessor, mutator}) {
                el.addAnnotation(SuppressWarnings.class, "\"deprecation\"");
            }
        }
        javaClass.addMethod(accessor);
        javaClass.addMethod(mutator);
    }
}

