/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.component;

import java.util.Collection;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.ajax4jsf.builder.component.ActionSource2PropertyProcessor;
import org.ajax4jsf.builder.component.ComponentPropertyProcessor;
import org.ajax4jsf.builder.component.ELPropertyProcessor;
import org.ajax4jsf.builder.component.ExpressionPropertyProcessor;
import org.ajax4jsf.builder.component.PrimitivePropertyProcessor;
import org.ajax4jsf.builder.component.PropertyProcessor;
import org.ajax4jsf.builder.component.state.ComponentStateManager;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.config.RendererBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.model.Argument;
import org.ajax4jsf.builder.model.JavaClass;
import org.ajax4jsf.builder.model.JavaConstructor;
import org.ajax4jsf.builder.model.JavaField;
import org.ajax4jsf.builder.model.JavaMethod;
import org.ajax4jsf.builder.model.JavaModifier;
import org.ajax4jsf.builder.model.JavaPackage;
import org.ajax4jsf.builder.model.MethodBody;

public class ComponentModelBuilder {
    private PropertyProcessor[] propertyProcessors = new PropertyProcessor[]{new ActionSource2PropertyProcessor(), new ExpressionPropertyProcessor(), new PrimitivePropertyProcessor(), new ELPropertyProcessor(), new ComponentPropertyProcessor()};

    public JavaClass build(ComponentBean componentBean, JSFGeneratorConfiguration configuration) {
        String superclassname = componentBean.getSuperclass();
        JavaClass javaClass = new JavaClass(componentBean.getSimpleClassName(), new JavaPackage(componentBean.getPackageName()));
        try {
            Class<?> superClass = Class.forName(superclassname, false, configuration.getClassLoader());
            javaClass.setSuperClass(superClass);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            javaClass.setSuperClass(UIComponentBase.class);
        }
        javaClass.addModifier(JavaModifier.PUBLIC);
        javaClass.addField(this.getComponentFamily(componentBean));
        javaClass.addField(this.getComponentType(componentBean));
        javaClass.addMethod(this.getConstructor(componentBean, javaClass));
        Collection<PropertyBean> properties = componentBean.getProperties();
        for (PropertyBean propertyBean : properties) {
            PropertyProcessor proc = null;
            for (int i = 0; i < this.propertyProcessors.length && proc == null; ++i) {
                PropertyProcessor processor = this.propertyProcessors[i];
                if (!processor.accept(propertyBean, javaClass, configuration)) continue;
                proc = processor;
            }
            if (proc == null) continue;
            proc.process(propertyBean, javaClass, configuration);
        }
        javaClass.addMethod(this.getComponentFamilyMethod(componentBean));
        ComponentStateManager stateManager = new ComponentStateManager(javaClass);
        JavaMethod saveState = this.getSaveStateTemplate();
        try {
            saveState.setMethodBody(stateManager.getSaveStateMethodBody(configuration));
        }
        catch (GeneratorException e) {
            e.printStackTrace();
        }
        javaClass.addMethod(saveState);
        JavaMethod restoreState = this.getRestoreStateTemplate();
        try {
            restoreState.setMethodBody(stateManager.getRestoreStateMethodBody(configuration));
        }
        catch (GeneratorException e) {
            e.printStackTrace();
        }
        javaClass.addMethod(restoreState);
        return javaClass;
    }

    private JavaMethod getComponentFamilyMethod(ComponentBean componentBean) {
        JavaMethod javaMethod = new JavaMethod("getFamily", String.class, new Argument[0]);
        javaMethod.addModifier(JavaModifier.PUBLIC);
        javaMethod.setMethodBody(new MethodBody(){

            public String toCode() {
                return "return COMPONENT_FAMILY;";
            }
        });
        return javaMethod;
    }

    private JavaMethod getRestoreStateTemplate() {
        JavaMethod method = new JavaMethod("restoreState", Void.TYPE, Argument.arg("context", FacesContext.class), Argument.arg("state", Object.class));
        method.addModifier(JavaModifier.PUBLIC);
        method.addAnnotation(Override.class);
        return method;
    }

    private JavaMethod getSaveStateTemplate() {
        JavaMethod method = new JavaMethod("saveState", Object.class, Argument.arg("context", FacesContext.class));
        method.addModifier(JavaModifier.PUBLIC);
        method.addAnnotation(Override.class);
        method.setMethodBody(new MethodBody(){

            public String toCode() {
                return "return super.saveState(context);";
            }
        });
        return method;
    }

    private JavaField getComponentType(ComponentBean componentBean) {
        JavaField field = new JavaField(String.class, "COMPONENT_TYPE");
        field.addModifier(JavaModifier.PUBLIC);
        field.addModifier(JavaModifier.STATIC);
        field.addModifier(JavaModifier.FINAL);
        field.setValue("\"" + componentBean.getName() + "\"");
        return field;
    }

    private JavaField getComponentFamily(ComponentBean componentBean) {
        JavaField field = new JavaField(String.class, "COMPONENT_FAMILY");
        field.addModifier(JavaModifier.PUBLIC);
        field.addModifier(JavaModifier.STATIC);
        field.addModifier(JavaModifier.FINAL);
        field.setValue("\"" + componentBean.getFamily() + "\"");
        return field;
    }

    private JavaMethod getConstructor(ComponentBean componentBean, JavaClass javaClass) {
        final RendererBean renderer = componentBean.getRenderer();
        JavaConstructor method = new JavaConstructor(javaClass, new Argument[0]);
        method.addModifier(JavaModifier.PUBLIC);
        method.setMethodBody(new MethodBody(method){

            public String toCode() {
                if (renderer != null) {
                    return "setRendererType(\"" + renderer.getName() + "\");";
                }
                return super.toCode();
            }
        });
        return method;
    }
}

