/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.component;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import org.ajax4jsf.builder.component.ComponentPropertyProcessor;
import org.ajax4jsf.builder.component.methods.VelocityMethodBody;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.model.JavaClass;
import org.ajax4jsf.builder.model.JavaField;
import org.ajax4jsf.builder.model.JavaMethod;
import org.ajax4jsf.builder.model.JavaModifier;
import org.ajax4jsf.builder.model.JavaPrimitive;

public class PrimitivePropertyProcessor
extends ComponentPropertyProcessor {
    public boolean accept(PropertyBean propertyBean, JavaClass javaClass, JSFGeneratorConfiguration configuration) {
        return propertyBean.isSimpleType() && super.accept(propertyBean, javaClass, configuration);
    }

    public void process(PropertyBean propertyBean, JavaClass javaClass, JSFGeneratorConfiguration configuration) {
        JavaField field = this.getField(propertyBean, configuration);
        JavaField field2 = new JavaField(Boolean.TYPE, field.getName() + "Set", "false");
        field2.addModifier(JavaModifier.PRIVATE);
        if (propertyBean.isTransient()) {
            field2.addModifier(JavaModifier.TRANSIENT);
        }
        JavaMethod accessor = this.getAccessor(configuration, propertyBean, field);
        try {
            VelocityMethodBody accessorMethodBody = propertyBean.isEl() ? new PrimitiveELPropertyAccessorMethodBody(configuration, field, field2, propertyBean) : new PrimitivePropertyAccessorMethodBody(configuration, field, field2);
            accessor.setMethodBody(accessorMethodBody);
        }
        catch (GeneratorException e) {
            e.printStackTrace();
        }
        JavaMethod mutator = this.getMutator(configuration, propertyBean, field);
        try {
            PrimitivePropertyMutatorMethodBody mutatorBody = new PrimitivePropertyMutatorMethodBody(configuration, field, field2);
            mutator.setMethodBody(mutatorBody);
        }
        catch (GeneratorException e) {
            e.printStackTrace();
        }
        javaClass.addField(field);
        javaClass.addField(field2);
        javaClass.addMethod(accessor);
        javaClass.addMethod(mutator);
    }

    class PrimitivePropertyMutatorMethodBody
    extends VelocityMethodBody {
        public PrimitivePropertyMutatorMethodBody(JSFGeneratorConfiguration configuration, JavaField field, JavaField field2) throws GeneratorException {
            super(configuration);
            this.getContext().put("field1", (Object)field);
            this.getContext().put("field2", (Object)field2);
        }

        public String getTemplate() {
            return "snippets/primitive-property-mutator.vm";
        }
    }

    class PrimitivePropertyAccessorMethodBody
    extends VelocityMethodBody {
        public PrimitivePropertyAccessorMethodBody(JSFGeneratorConfiguration configuration, JavaField field, JavaField field2) throws GeneratorException {
            super(configuration);
            this.getContext().put("field1", (Object)field);
            this.getContext().put("field2", (Object)field2);
        }

        public String getTemplate() {
            return "snippets/primitive-property-accessor.vm";
        }
    }

    class PrimitiveELPropertyAccessorMethodBody
    extends VelocityMethodBody {
        public PrimitiveELPropertyAccessorMethodBody(JSFGeneratorConfiguration configuration, JavaField field, JavaField field2, PropertyBean property) throws GeneratorException {
            super(configuration);
            this.getContext().put("field1", (Object)field);
            this.getContext().put("field2", (Object)field2);
            this.getContext().put("wrapperClass", JavaPrimitive.wrapperType(field.getType()));
            this.getContext().put("property", (Object)property);
            this.addType(ValueExpression.class);
            this.addType(ELException.class);
            this.addType(FacesException.class);
        }

        public String getTemplate() {
            return "snippets/primitive-el-property-accessor.vm";
        }
    }
}

