/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.render;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ajax4jsf.builder.model.JavaAnnotation;
import org.ajax4jsf.builder.model.JavaComment;
import org.ajax4jsf.builder.model.JavaLanguageElement;
import org.ajax4jsf.builder.model.JavaModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaLanguageElementRenderer<T extends JavaLanguageElement> {
    public void renderModifiers(T element, PrintWriter out) {
        Set<JavaModifier> modifiers = ((JavaLanguageElement)element).getModifiers();
        for (JavaModifier javaModifier : modifiers) {
            out.print((Object)javaModifier);
            out.print(" ");
        }
    }

    public void renderAnnotations(T element, PrintWriter out) {
        List<JavaAnnotation> annotations = ((JavaLanguageElement)element).getAnnotations();
        if (annotations != null) {
            for (JavaAnnotation javaAnnotation : annotations) {
                out.print("@" + javaAnnotation.getType().getSimpleName());
                List<String> arguments = javaAnnotation.getArguments();
                if (arguments != null && !arguments.isEmpty()) {
                    out.print("(");
                    Iterator<String> iterator = arguments.iterator();
                    while (iterator.hasNext()) {
                        String string = iterator.next();
                        out.print(string);
                        if (!iterator.hasNext()) continue;
                        out.print(", ");
                    }
                    out.print(")");
                }
                out.println();
            }
        }
    }

    public void renderComments(T element, PrintWriter out) {
        List<JavaComment> comments = ((JavaLanguageElement)element).getComments();
        for (JavaComment javaComment : comments) {
            out.println("/*");
            out.println("* " + javaComment.getValue());
            out.println("*/");
        }
    }

    public abstract void render(T var1, PrintWriter var2);
}

