/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.html;

import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.TreeSet;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.el.ELParser;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.ajax4jsf.templatecompiler.elements.html.HTMLAttributes;
import org.ajax4jsf.templatecompiler.elements.html.HTMLTags;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HTMLElement
extends TemplateElementBase {
    private static final String PRE_TAG_NAME = "pre";
    private static final String PASS_THRU_ATTR = "x:passThruWithExclusions";
    private static final List<String> DEFAULT_EXCLUSIONS = Arrays.asList("class", "id");
    private static final String TEMPLATE = "META-INF/templates/templatecompiler/HTMLElement.vm";
    private String htmlTag;
    private String htmlText;
    private HTMLAttributes htmlAttributes = new HTMLAttributes();
    private Collection<String> passThruAttributes = null;
    private CompilationContext componentBean;

    public HTMLElement(Node element, CompilationContext componentBean) {
        super(element, componentBean);
        this.htmlTag = element.getNodeName();
        this.componentBean = componentBean;
        this.processingAttributes(element.getAttributes());
    }

    public String getBeginElement() throws CompilationException {
        VelocityContext context = new VelocityContext();
        context.put("htmlTag", (Object)this.htmlTag);
        context.put("htmlAttributes", (Object)this.htmlAttributes.getAttributes());
        context.put("passThruAttributes", this.passThruAttributes);
        if (this.htmlText != null) {
            context.put("htmlText", (Object)this.htmlText);
        }
        return this.componentBean.processTemplate(this.getTemplateName(), context);
    }

    protected String getTemplateName() {
        return TEMPLATE;
    }

    public String getEndElement() {
        Object[] objects = new Object[]{this.htmlTag};
        String sReturnValue = new Formatter().format("writer.endElement(\"%s\");", objects).toString();
        return sReturnValue;
    }

    public void processingAttributes(NamedNodeMap attributes) {
        if (attributes == null) {
            return;
        }
        for (int iElement = 0; iElement != attributes.getLength(); ++iElement) {
            Node attribute = attributes.item(iElement);
            String attributeName = attribute.getNodeName();
            String attributeValue = attribute.getNodeValue();
            if (attributeName.equals(PASS_THRU_ATTR)) {
                this.processingPassThruAtrribute(attributeValue);
                continue;
            }
            this.htmlAttributes.addAttribute(attributeName, ELParser.compileEL(attributeValue, this.componentBean));
        }
    }

    private void processingPassThruAtrribute(String listPassThruAttributes) {
        this.passThruAttributes = new TreeSet<String>(HTMLTags.getAttributes(this.htmlTag));
        String[] excludeAttributes = listPassThruAttributes.split(",");
        this.passThruAttributes.removeAll(DEFAULT_EXCLUSIONS);
        for (String attribute : excludeAttributes) {
            this.passThruAttributes.remove(attribute);
        }
    }

    public void setText(String nodeText) {
        String tempStr = null;
        if (nodeText.trim().length() != 0) {
            tempStr = this.htmlTag.compareToIgnoreCase(PRE_TAG_NAME) == 0 ? nodeText : nodeText.trim();
        }
        if (null != tempStr) {
            this.htmlText = null == this.htmlText ? ELParser.compileEL(tempStr, this.componentBean) : this.htmlText + ELParser.compileEL(tempStr, this.componentBean);
        }
    }
}

