/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.dtd.wutka;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDParser;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.dtd.Attribute;
import org.richfaces.dtd.DocumentDefinition;
import org.richfaces.dtd.DocumentDefinitionFactory;
import org.richfaces.dtd.Element;

public class WutkaDefinitionFactory
extends DocumentDefinitionFactory {
    private final Log log = LogFactory.getLog(this.getClass());
    private Map<URL, DocumentDefinition> definitions = new HashMap<URL, DocumentDefinition>();

    public synchronized DocumentDefinition getDocumentDefinition(URL resource) {
        DocumentDefinition def = null;
        if (this.definitions.containsKey(resource)) {
            def = this.definitions.get(resource);
        } else {
            try {
                def = this.initDefinition(resource);
            }
            catch (Exception e) {
                this.log.error((Object)"An error has occured", (Throwable)e);
            }
            if (def != null) {
                this.definitions.put(resource, def);
            }
        }
        return def;
    }

    private DocumentDefinition initDefinition(URL resource) throws Exception {
        DTD dtd = new DTDParser(resource).parse();
        Element rootElement = this.fromWutka(dtd.rootElement);
        DocumentDefinition definition = new DocumentDefinition(resource, rootElement);
        Enumeration elements = dtd.elements.elements();
        while (elements.hasMoreElements()) {
            DTDElement element = (DTDElement)elements.nextElement();
            definition.addElement(this.fromWutka(element));
        }
        return definition;
    }

    private Attribute fromWutka(DTDAttribute attr) {
        return new Attribute(attr.name);
    }

    private Element fromWutka(DTDElement element) {
        if (element == null) {
            return null;
        }
        Element e = new Element(element.getName());
        Enumeration attrs = element.attributes.elements();
        while (attrs.hasMoreElements()) {
            e.addAttribute(this.fromWutka((DTDAttribute)attrs.nextElement()));
        }
        return e;
    }
}

