/*
 * $Id: AptBuilder.java 17243 2010-05-25 23:55:03Z alexsmirnov $
 *
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */



package org.richfaces.cdk.apt;

import java.util.Set;

import javax.tools.JavaCompiler.CompilationTask;

import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.LibraryBuilder;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.model.ComponentLibrary;

import com.google.inject.Inject;

/**
 * <p class="changed_added_4_0">
 * That class compiles files from sources and process annotations
 * </p>
 *
 * @author asmirnov@exadel.com
 *
 */
public class AptBuilder implements LibraryBuilder {
    
    @Inject
    private Logger log;
    
    @Inject
    private CompilationTaskFactory taskFactory;

    @Inject                  
    private Set<CdkWriter> generators;

    public void build() throws CdkException {
        CompilationTask task = taskFactory.get();
        if (!task.call()) {
            throw new AptException("Compilation error");
        }
    }

    @Override
    public void generate(ComponentLibrary library) throws CdkException {
        if (0 == log.getErrorCount()) {
            // processing over, generate files.
            for (CdkWriter generator : generators) {
                generator.render(library);
            }
        }
    }
}
