/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.richfaces.cdk.CdkClassLoader;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.JavaLogger;
import org.richfaces.cdk.LibraryBuilder;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelValidator;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.OutputFileManagerImpl;
import org.richfaces.cdk.OutputImpl;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.RichFacesConventions;
import org.richfaces.cdk.SourceFileManagerImpl;
import org.richfaces.cdk.SourceImpl;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.apt.AptModule;
import org.richfaces.cdk.generate.java.ClassGeneratorModule;
import org.richfaces.cdk.generate.taglib.TaglibModule;
import org.richfaces.cdk.model.ModelModule;
import org.richfaces.cdk.model.validator.ValidatorImpl;
import org.richfaces.cdk.templatecompiler.TemplateModule;
import org.richfaces.cdk.xmlconfig.XmlModule;

public class Generator {
    public static final String RENDERER_UTILS_CLASS = "rendererUtils";
    public static final String OPTIONS = "OPTIONS";
    private CdkClassLoader loader;
    private Logger log = new JavaLogger();
    private Injector injector;
    private String namespace;
    private Locale locale = Locale.getDefault();
    private Charset charset = Charset.defaultCharset();
    private Map<Outputs, FileManager> outputFolders = Maps.newEnumMap(Outputs.class);
    private Map<Sources, FileManager> sources = Maps.newEnumMap(Sources.class);
    private LibraryBuilder libraryBuilder;
    private Map<String, String> options = Maps.newHashMap();

    public Generator() {
        EmptyFileManager emptyFileManager = new EmptyFileManager();
        for (Sources sources : Sources.values()) {
            this.sources.put(sources, emptyFileManager);
        }
        for (Enum enum_ : Outputs.values()) {
            this.outputFolders.put((Outputs)enum_, emptyFileManager);
        }
    }

    public void setLoader(CdkClassLoader loader) {
        this.loader = loader;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void addOutputFolder(Outputs type, File outputFolder) {
        this.outputFolders.put(type, new OutputFileManagerImpl(outputFolder));
    }

    public void addSources(Sources type, Iterable<File> files, Iterable<File> folders) {
        this.sources.put(type, new SourceFileManagerImpl(files, folders));
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void init() {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new CdkConfigurationModule(), new AptModule(), new ModelModule(), new ClassGeneratorModule(), new TemplateModule(), new XmlModule(), new TaglibModule()});
        if (!this.log.isDebugEnabled()) {
            try {
                freemarker.log.Logger.selectLoggerLibrary((int)0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.libraryBuilder = (LibraryBuilder)this.injector.getInstance(LibraryBuilder.class);
    }

    public void execute() {
        Preconditions.checkNotNull((Object)this.libraryBuilder, (Object)"initialized");
        this.libraryBuilder.build();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public class CdkConfigurationModule
    extends AbstractModule {
        protected void configure() {
            this.bind(CdkClassLoader.class).toInstance((Object)Generator.this.loader);
            this.bind(Logger.class).toInstance((Object)Generator.this.log);
            this.bind(Locale.class).toInstance((Object)Generator.this.locale);
            this.bind(Charset.class).toInstance((Object)Generator.this.charset);
            this.bind(Generator.class).toInstance((Object)Generator.this);
            for (Map.Entry entry : Generator.this.outputFolders.entrySet()) {
                this.bind(FileManager.class).annotatedWith((Annotation)new OutputImpl((Outputs)((Object)entry.getKey()))).toInstance(entry.getValue());
            }
            for (Map.Entry entry : Generator.this.sources.entrySet()) {
                this.bind(FileManager.class).annotatedWith((Annotation)new SourceImpl((Sources)((Object)entry.getKey()))).toInstance(entry.getValue());
            }
            this.bind(NamingConventions.class).to(RichFacesConventions.class);
            this.bind(ModelValidator.class).to(ValidatorImpl.class);
            Names.bindProperties((Binder)this.binder(), (Map)Generator.this.options);
        }
    }

    public static final class EmptyFileManager
    implements FileManager {
        @Override
        public Iterable<File> getFolders() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<File> getFiles() {
            return Collections.emptyList();
        }

        @Override
        public File getFile(String path) throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        @Override
        public Writer createOutput(String path, long lastModified) throws IOException {
            throw new IOException("read-only");
        }
    }
}

