/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.InvalidNameException;
import org.richfaces.cdk.model.Name;
import org.richfaces.cdk.util.Strings;

public final class RichFacesConventions
implements NamingConventions {
    private static final String ABSTRACT = "Abstract";
    private static final String BASE = "Base";
    private static final String UI = "UI";
    private static final String[] COMPONENT_SUFFIXES = new String[]{"Base"};
    private static final String[] COMPONENT_PREFIXES = new String[]{"UI", "Abstract"};
    private String baseName;

    @Override
    public FacesId inferComponentType(ClassName componentClass) throws InvalidNameException {
        int i;
        if (null == componentClass) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create(componentClass.toString());
        String baseName = this.getBaseName();
        if (null != baseName) {
            name.setPrefix(baseName);
        }
        name.setClassifier(null);
        name.setMarkup(null);
        String simpleName = name.getSimpleName();
        for (i = 0; i < COMPONENT_PREFIXES.length; ++i) {
            if (!simpleName.startsWith(COMPONENT_PREFIXES[i])) continue;
            simpleName = simpleName.substring(COMPONENT_PREFIXES[i].length());
            break;
        }
        for (i = 0; i < COMPONENT_SUFFIXES.length; ++i) {
            if (!simpleName.endsWith(COMPONENT_SUFFIXES[i])) continue;
            simpleName = simpleName.substring(0, simpleName.length() - COMPONENT_SUFFIXES[i].length());
            break;
        }
        name.setSimpleName(simpleName);
        return new FacesId(name.toString());
    }

    @Override
    public ClassName inferUIComponentClass(FacesId componentType) throws InvalidNameException {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create(componentType.toString());
        name.setClassifier(Name.Classifier.component);
        name.setMarkup(null);
        name.setSimpleName(UI + name.getSimpleName());
        return new ClassName(name.toString());
    }

    @Override
    public FacesId inferUIComponentFamily(FacesId componentType) {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        return componentType;
    }

    @Override
    public ClassName inferTagHandlerClass(FacesId componentType, String markup) {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create(componentType.toString());
        name.setClassifier(Name.Classifier.taglib);
        name.setMarkup(markup);
        name.setSimpleName(name.getSimpleName() + "Handler");
        return new ClassName(name.toString());
    }

    @Override
    public String inferTagName(FacesId componentType) {
        if (null == componentType) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create(componentType.toString());
        return Strings.firstToLowerCase(name.getSimpleName());
    }

    protected String getBaseName() {
        return this.baseName;
    }

    @Override
    public String inferRendererTypeByRendererClass(ClassName rendererClass) {
        Pattern pattern = Pattern.compile("^(.*).renderkit.(.*\\.)?(.*)RendererBase$");
        Matcher matcher = pattern.matcher(rendererClass.getName());
        if (matcher.matches()) {
            return matcher.group(1) + "." + matcher.group(3) + "Renderer";
        }
        return "";
    }

    @Override
    public String inferRendererTypeByComponentType(FacesId componentType) {
        return componentType + "Renderer";
    }

    @Override
    public String inferComponentFamily(FacesId type) {
        return null;
    }

    @Override
    public String inferTemplate(FacesId type) {
        return null;
    }

    @Override
    public String inferRendererTypeByTemplatePath(String templateName) {
        return null;
    }

    @Override
    public String inferRendererName(FacesId type) {
        return null;
    }

    @Override
    public String inferRendererBaseName(FacesId type) {
        return null;
    }

    @Override
    public String inferComponentTypeByRendererClass(String s) {
        Pattern pattern = Pattern.compile("^(.*).renderkit.(.*\\.)?(.*)RendererBase$");
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1) + "." + matcher.group(3);
        }
        return "";
    }

    @Override
    public String inferComponentFamilyByRendererClass(String s) {
        return this.inferComponentTypeByRendererClass(s);
    }

    @Override
    public ClassName inferBehaviorClass(FacesId id) {
        if (null == id) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create(id.toString());
        name.setClassifier(Name.Classifier.component);
        name.setMarkup("behavior");
        return new ClassName(name.toString());
    }

    @Override
    public FacesId inferBehaviorType(ClassName targetClass) {
        int i;
        if (null == targetClass) {
            throw new IllegalArgumentException();
        }
        Name name = Name.create(targetClass.toString());
        String baseName = this.getBaseName();
        if (null != baseName) {
            name.setPrefix(baseName);
        }
        name.setClassifier(null);
        name.setMarkup(null);
        String simpleName = name.getSimpleName();
        for (i = 0; i < COMPONENT_PREFIXES.length; ++i) {
            if (!simpleName.startsWith(COMPONENT_PREFIXES[i])) continue;
            simpleName = simpleName.substring(COMPONENT_PREFIXES[i].length());
            break;
        }
        for (i = 0; i < COMPONENT_SUFFIXES.length; ++i) {
            if (!simpleName.endsWith(COMPONENT_SUFFIXES[i])) continue;
            simpleName = simpleName.substring(0, simpleName.length() - COMPONENT_SUFFIXES[i].length());
            break;
        }
        name.setSimpleName(simpleName);
        return new FacesId(name.toString());
    }

    @Override
    public String inferTaglibName(String uri) throws InvalidNameException {
        try {
            URI taglibUri = URI.create(uri);
            String path = taglibUri.getPath();
            if (null != path) {
                int indexOfDot;
                int lastIndexOfPathSeparator = path.lastIndexOf(47);
                if (lastIndexOfPathSeparator >= 0) {
                    path = path.substring(lastIndexOfPathSeparator + 1);
                }
                if ((indexOfDot = path.indexOf(46)) > 0) {
                    path = path.substring(0, indexOfDot);
                }
                return path;
            }
            throw new InvalidNameException("Invalid taglib uri, no path defined " + uri);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidNameException("Invalid taglib uri " + uri + " , " + e.getMessage());
        }
    }

    @Override
    public String inferTaglibUri(ComponentLibrary library) {
        return "http://richfaces.org/a4j";
    }
}

