/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.InvalidNameException;
import org.richfaces.cdk.util.PropertyUtils;

public class AptSourceUtils
implements SourceUtils {
    private static final Set<String> PROPERTIES = new HashSet<String>(Arrays.asList("getEventNames", "getDefaultEventName", "getClientBehaviors", "getFamily"));
    private final ProcessingEnvironment processingEnv;
    @Inject
    private Logger log;

    public AptSourceUtils(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public Set<SourceUtils.BeanProperty> getBeanPropertiesAnnotatedWith(Class<? extends Annotation> annotation, TypeElement type) {
        HashSet<SourceUtils.BeanProperty> properties = new HashSet<SourceUtils.BeanProperty>();
        List<? extends Element> members = this.processingEnv.getElementUtils().getAllMembers(type);
        for (Element element : members) {
            boolean annotated = null != element.getAnnotation(annotation);
            if (!annotated) continue;
            if (ElementKind.METHOD.equals((Object)element.getKind())) {
                this.processMethod(properties, element, annotated);
                continue;
            }
            if (!ElementKind.FIELD.equals((Object)element.getKind())) continue;
            this.processFiled(properties, element);
        }
        return properties;
    }

    @Override
    public Set<SourceUtils.BeanProperty> getAbstractBeanProperties(TypeElement type) {
        this.log.debug((CharSequence)"AptSourceUtils.getAbstractBeanProperties");
        this.log.debug((CharSequence)("  - type = " + type));
        HashSet<SourceUtils.BeanProperty> properties = new HashSet<SourceUtils.BeanProperty>();
        List<? extends Element> members = this.processingEnv.getElementUtils().getAllMembers(type);
        Map<String, List<ExecutableElement>> props = this.groupMethodsBySignature(members);
        this.removeNotAbstractGroups(props);
        for (List<ExecutableElement> methods : props.values()) {
            ExecutableElement method = methods.get(0);
            if (!ElementKind.METHOD.equals((Object)method.getKind()) || PROPERTIES.contains(method.getSimpleName().toString())) continue;
            this.processMethod(properties, method, false);
        }
        return properties;
    }

    private void removeNotAbstractGroups(Map<String, List<ExecutableElement>> props) {
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (Map.Entry<String, List<ExecutableElement>> entry : props.entrySet()) {
            List<ExecutableElement> value = entry.getValue();
            for (ExecutableElement element : value) {
                if (this.isAbstract(element)) continue;
                removeKeys.add(entry.getKey());
            }
        }
        for (String removeKey : removeKeys) {
            props.remove(removeKey);
        }
    }

    private Map<String, List<ExecutableElement>> groupMethodsBySignature(List<? extends Element> members) {
        HashMap<String, List<ExecutableElement>> props = new HashMap<String, List<ExecutableElement>>();
        for (Element element : members) {
            if (!ElementKind.METHOD.equals((Object)element.getKind()) || PROPERTIES.contains(element.getSimpleName().toString())) continue;
            ExecutableElement method = (ExecutableElement)element;
            String signature = this.getSignature(method);
            ArrayList<ExecutableElement> methods = (ArrayList<ExecutableElement>)props.get(signature);
            if (methods == null) {
                methods = new ArrayList<ExecutableElement>(5);
                props.put(signature, methods);
            }
            methods.add(method);
        }
        return props;
    }

    private String getSignature(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        List<? extends VariableElement> methodParams = method.getParameters();
        StringBuilder builder = new StringBuilder(name);
        for (VariableElement variableElement : methodParams) {
            builder.append(":").append(variableElement.getKind().name());
        }
        return builder.toString();
    }

    private void processFiled(Set<SourceUtils.BeanProperty> properties, Element childElement) {
        AptBeanProperty property = new AptBeanProperty(childElement.getSimpleName().toString());
        property.type = this.asClassDescription(childElement.asType());
        property.element = childElement;
        property.exists = true;
        properties.add(property);
    }

    private void processMethod(Set<SourceUtils.BeanProperty> properties, Element childElement, boolean annotated) {
        boolean exists;
        ExecutableElement method = (ExecutableElement)childElement;
        boolean bl = exists = !this.isAbstract(method);
        if (!annotated && exists) {
            this.log.debug((CharSequence)("      - " + childElement.getSimpleName() + " : didn't annotated and didn't abstract."));
            return;
        }
        TypeMirror propertyType = method.getReturnType();
        List<? extends VariableElement> parameters = method.getParameters();
        if (TypeKind.VOID.equals((Object)propertyType.getKind()) && 1 == parameters.size()) {
            propertyType = parameters.get(0).asType();
        } else if (!parameters.isEmpty()) {
            this.log.debug((CharSequence)("      - " + childElement.getSimpleName() + " : Invalid method signature for a bean property."));
            return;
        }
        try {
            String name = PropertyUtils.methodToName(childElement.getSimpleName().toString());
            AptBeanProperty property = new AptBeanProperty(name);
            property.type = this.asClassDescription(propertyType);
            property.element = childElement;
            property.exists = exists;
            properties.add(property);
            this.log.debug((CharSequence)("      - " + childElement.getSimpleName() + " : was added."));
        }
        catch (InvalidNameException e) {
            this.log.debug((CharSequence)("      - " + childElement.getSimpleName() + " : Invalid method name for a bean property, throw."));
        }
    }

    private boolean isAbstract(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private ClassName asClassDescription(TypeMirror type) {
        return new ClassName(((Object)type).toString());
    }

    @Override
    public String getDocComment(Element componentElement) {
        return this.processingEnv.getElementUtils().getDocComment(componentElement);
    }

    @Override
    public Object getConstant(TypeElement componentElement, String name) {
        List<VariableElement> fieldsIn = ElementFilter.fieldsIn(this.processingEnv.getElementUtils().getAllMembers(componentElement));
        Object value = null;
        for (VariableElement field : fieldsIn) {
            Set<Modifier> modifiers = field.getModifiers();
            if (!modifiers.contains((Object)Modifier.FINAL) || !modifiers.contains((Object)Modifier.STATIC) || !field.getSimpleName().toString().equals(name)) continue;
            value = field.getConstantValue();
        }
        return value;
    }

    @Override
    public void visitSupertypes(TypeElement type, SourceUtils.SuperTypeVisitor visitor) {
        this.visitSupertypes(type.asType(), visitor);
    }

    private void visitSupertypes(TypeMirror type, SourceUtils.SuperTypeVisitor visitor) {
        List<? extends TypeMirror> supertypes = this.processingEnv.getTypeUtils().directSupertypes(type);
        for (TypeMirror typeMirror : supertypes) {
            this.visitSupertypes(typeMirror, visitor);
        }
        visitor.visit(type);
    }

    @Override
    public TypeElement asTypeElement(ClassName type) {
        return this.processingEnv.getElementUtils().getTypeElement(type.toString());
    }

    @Override
    public TypeElement asTypeElement(TypeMirror mirror) {
        if (TypeKind.DECLARED.equals((Object)mirror.getKind())) {
            return (TypeElement)this.processingEnv.getTypeUtils().asElement(mirror);
        }
        return null;
    }

    protected final class AptBeanProperty
    implements SourceUtils.BeanProperty {
        private Element element;
        private boolean exists;
        private final String name;
        private ClassName type;

        public AptBeanProperty(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AptBeanProperty other = (AptBeanProperty)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDocComment() {
            return AptSourceUtils.this.processingEnv.getElementUtils().getDocComment(this.element);
        }

        @Override
        public ClassName getType() {
            return this.type;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            return this.element.getAnnotationMirrors();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return this.element.getAnnotation(annotationType);
        }
    }
}

