/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.cdk.annotations.Signature;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.AttributesProcessor;
import org.richfaces.cdk.apt.processors.DescriptionProcessor;
import org.richfaces.cdk.apt.processors.EmptyAnnotationValueVisitor;
import org.richfaces.cdk.model.BeanModelBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.util.Strings;
import org.richfaces.cdk.xmlconfig.FragmentParser;

public class AttributesProcessorImpl
implements AttributesProcessor {
    private static final String SIGNATURE_NONE_CLASS_NAME = Signature.NONE.class.getName().replace('$', '.');
    private static final String STRING_NAME = String.class.getName();
    @Inject
    private Logger log;
    private final DescriptionProcessor descriptionProcessor;
    private final Provider<SourceUtils> utilsProvider;
    private final FragmentParser parser;

    @Inject
    public AttributesProcessorImpl(DescriptionProcessor descriptionProcessor, Provider<SourceUtils> utilsProvider, FragmentParser parser) {
        this.descriptionProcessor = descriptionProcessor;
        this.utilsProvider = utilsProvider;
        this.parser = parser;
    }

    protected void processAttribute(SourceUtils.BeanProperty beanProperty, PropertyBase attribute) {
        attribute.setType(beanProperty.getType());
        Attribute attributeAnnotarion = beanProperty.getAnnotation(Attribute.class);
        if (attributeAnnotarion == null) {
            String value;
            attribute.setGenerate(!beanProperty.isExists());
            attribute.setDescription(beanProperty.getDocComment());
            attribute.setHidden(true);
            if (attribute.getType().isPrimitive() && (value = this.getPimitiveDefaultValue(attribute.getType().getName())) != null) {
                attribute.setDefaultValue(value);
            }
        } else {
            attribute.setHidden(attributeAnnotarion.hidden());
            attribute.setLiteral(attributeAnnotarion.literal());
            attribute.setPassThrough(attributeAnnotarion.passThrough());
            attribute.setRequired(attributeAnnotarion.required());
            attribute.setReadOnly(attributeAnnotarion.readOnly());
            attribute.setGenerate(attributeAnnotarion.generate() || !beanProperty.isExists());
            this.descriptionProcessor.processDescription(attribute, attributeAnnotarion.description(), beanProperty.getDocComment());
            this.setDefaultValue(attribute, attributeAnnotarion);
            String suggestedValue = attributeAnnotarion.suggestedValue();
            if (!Strings.isEmpty(suggestedValue)) {
                attribute.setSuggestedValue(suggestedValue);
            }
            AnnotationValue signatureMirror = null;
            List<? extends AnnotationMirror> mirrors = beanProperty.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : mirrors) {
                if (!Attribute.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    Name simpleName = entry.getKey().getSimpleName();
                    if (!"signature".equals(simpleName.toString())) continue;
                    signatureMirror = entry.getValue();
                }
            }
            attribute.setSignature(this.getSignature(attributeAnnotarion.signature(), signatureMirror));
            for (EventName event : attributeAnnotarion.events()) {
                this.setBehaviorEvent(attribute, event);
            }
        }
    }

    private void setDefaultValue(PropertyBase attribute, Attribute attributeAnnotarion) {
        String defaultValue = attributeAnnotarion.defaultValue();
        if (Strings.isEmpty(defaultValue)) {
            String pimitiveDefaultValue;
            if (attribute.getType().isPrimitive() && (pimitiveDefaultValue = this.getPimitiveDefaultValue(attribute.getType().getName())) != null) {
                attribute.setDefaultValue(pimitiveDefaultValue);
            }
        } else {
            if (STRING_NAME.equals(attribute.getType().toString())) {
                defaultValue = "\"" + defaultValue + "\"";
            }
            attribute.setDefaultValue(defaultValue);
        }
    }

    private String getPimitiveDefaultValue(String typeName) {
        if (this.isInstace(Boolean.TYPE, typeName)) {
            return "false";
        }
        if (this.isInstace(Integer.TYPE, typeName)) {
            return "Integer.MIN_VALUE";
        }
        if (this.isInstace(Long.TYPE, typeName)) {
            return "Long.MIN_VALUE";
        }
        if (this.isInstace(Byte.TYPE, typeName)) {
            return "Byte.MIN_VALUE";
        }
        if (this.isInstace(Short.TYPE, typeName)) {
            return "Short.MIN_VALUE";
        }
        if (this.isInstace(Float.TYPE, typeName)) {
            return "Float.MIN_VALUE";
        }
        if (this.isInstace(Double.TYPE, typeName)) {
            return "Double.MIN_VALUE";
        }
        if (this.isInstace(Character.TYPE, typeName)) {
            return "Character.MIN_VALUE";
        }
        return null;
    }

    private boolean isInstace(Class<?> byteClass, String typeName) {
        return byteClass.getSimpleName().equals(typeName);
    }

    private List<ClassName> getSignature(Signature signature, AnnotationValue signatureMirror) {
        String returnType;
        try {
            returnType = signature.returnType().getName();
        }
        catch (MirroredTypeException e) {
            TypeMirror returnTypeMirror = e.getTypeMirror();
            returnType = ((Object)returnTypeMirror).toString();
        }
        if (signature != null && !SIGNATURE_NONE_CLASS_NAME.equals(returnType)) {
            return this.getSignatureParams(signature, signatureMirror);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private List<ClassName> getSignatureParams(Signature signature, AnnotationValue signatureMirror) {
        ArrayList parameters = Lists.newArrayList();
        try {
            void var6_11;
            Class[] arr$ = signature.parameters();
            int len$ = arr$.length;
            boolean bl = false;
            while (var6_11 < len$) {
                Class parameterType = arr$[var6_11];
                parameters.add(new ClassName(parameterType.getName()));
                ++var6_11;
            }
        }
        catch (MirroredTypeException e) {
            AnnotationValue params = signatureMirror.accept(new EmptyAnnotationValueVisitor<AnnotationValue>(){

                @Override
                public AnnotationValue visitAnnotation(AnnotationMirror a, Object o) {
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : a.getElementValues().entrySet()) {
                        if (!"parameters".equals(entry.getKey().getSimpleName().toString())) continue;
                        return entry.getValue();
                    }
                    return null;
                }
            }, null);
            List<? extends AnnotationValue> list = params.accept(new EmptyAnnotationValueVisitor<List<? extends AnnotationValue>>(){

                @Override
                public List<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> vals, Object o) {
                    return vals;
                }
            }, null);
            for (AnnotationValue annotationValue : list) {
                parameters.add(annotationValue.accept(new EmptyAnnotationValueVisitor<ClassName>(){

                    @Override
                    public ClassName visitType(TypeMirror t, Object o) {
                        return new ClassName(((Object)t).toString());
                    }
                }, null));
            }
        }
        catch (MirroredTypesException e) {
            for (TypeMirror typeMirror : e.getTypeMirrors()) {
                parameters.add(new ClassName(((Object)typeMirror).toString()));
            }
        }
        return parameters;
    }

    private void setBehaviorEvent(PropertyBase attribute, EventName eventName) {
        if (null != eventName) {
            org.richfaces.cdk.model.EventName event = new org.richfaces.cdk.model.EventName();
            event.setName(eventName.value());
            event.setDefaultEvent(eventName.defaultEvent());
            attribute.getEventNames().add(event);
        }
    }

    @Override
    public void processType(final BeanModelBase component, TypeElement element) throws CdkException {
        this.log.debug((CharSequence)"AttributesProcessorImpl.processType");
        this.log.debug((CharSequence)("  -> component = " + component));
        this.log.debug((CharSequence)("  -> typeElement = " + element));
        this.log.debug((CharSequence)"  -- Process XML files with standard attributes definitions.");
        this.log.debug((CharSequence)"     -> sourceUtils.visitSupertypes...");
        SourceUtils sourceUtils = this.getSourceUtils();
        sourceUtils.visitSupertypes(element, new SourceUtils.SuperTypeVisitor(){

            @Override
            public void visit(TypeMirror type) {
                try {
                    AttributesProcessorImpl.this.log.debug((CharSequence)("        -> visit - " + ((Object)type).toString()));
                    component.getAttributes().addAll(AttributesProcessorImpl.this.parseProperties(((Object)type).toString() + ".xml"));
                }
                catch (CdkException cdkException) {
                    // empty catch block
                }
            }
        });
        this.log.debug((CharSequence)"  -- Process Java files.");
        HashSet properties = Sets.newHashSet();
        properties.addAll(sourceUtils.getBeanPropertiesAnnotatedWith(Attribute.class, element));
        properties.addAll(sourceUtils.getAbstractBeanProperties(element));
        for (SourceUtils.BeanProperty beanProperty : properties) {
            this.processAttribute(beanProperty, component.getOrCreateAttribute(beanProperty.getName()));
        }
    }

    private Collection<? extends PropertyBase> parseProperties(String uri) {
        return this.parser.parseProperties("urn:attributes:" + uri);
    }

    private SourceUtils getSourceUtils() {
        return (SourceUtils)this.utilsProvider.get();
    }

    @Override
    public void processXmlFragment(BeanModelBase component, String ... attributesConfig) {
        for (String attributes : attributesConfig) {
            try {
                component.getAttributes().addAll(this.parseProperties(attributes));
            }
            catch (CdkException e) {
                // empty catch block
            }
        }
    }
}

