/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.JsfBehavior;
import org.richfaces.cdk.apt.processors.AttributesProcessor;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.BehaviorModel;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.FacesId;

@SupportedAnnotationTypes(value={"javax.faces.component.FacesComponent", "org.richfaces.cdk.annotations.JsfBehavior"})
public class BehaviorProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        JsfBehavior behavior = element.getAnnotation(JsfBehavior.class);
        BehaviorModel behaviorModel = new BehaviorModel(new FacesId(behavior.id()));
        this.setClassNames((TypeElement)element, behaviorModel, behavior.generate());
        this.setTagInfo(behavior.tag(), behaviorModel);
        AttributesProcessor attributesProcessor = this.getAttributeProcessor();
        attributesProcessor.processXmlFragment(behaviorModel, behavior.attributes());
        attributesProcessor.processType(behaviorModel, (TypeElement)element);
        this.setDescription(behaviorModel, behavior.description(), this.getDocComment(element));
        library.getBehaviors().add(behaviorModel);
    }

    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return JsfBehavior.class;
    }
}

