/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.annotations.Facet;
import org.richfaces.cdk.annotations.JsfComponent;
import org.richfaces.cdk.annotations.JsfRenderer;
import org.richfaces.cdk.annotations.RendererSpecificComponent;
import org.richfaces.cdk.annotations.Tag;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.AttributesProcessor;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.JsfSubComponent;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.apt.processors.RendererProcessor;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.FacetModel;
import org.richfaces.cdk.util.Strings;

public class ComponentProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    public static final String COMPONENT_FAMILY = "COMPONENT_FAMILY";
    public static final String COMPONENT_TYPE = "COMPONENT_TYPE";
    @Inject
    private RendererProcessor rendererProcessor;

    @Override
    public void process(Element componentElement, ComponentLibrary library) {
        JsfComponent annotation = componentElement.getAnnotation(JsfComponent.class);
        if (annotation == null) {
            return;
        }
        ComponentModel component = new ComponentModel();
        this.setClassNames((TypeElement)componentElement, component, annotation.generate());
        this.setComponentProperties((TypeElement)componentElement, component, annotation);
        library.getComponents().add(component);
        for (RendererSpecificComponent subcomponent : annotation.components()) {
            JsfSubComponent subAnnotation = new JsfSubComponent(subcomponent, annotation);
            ComponentModel subcomponentModel = new ComponentModel();
            subcomponentModel.setBaseClass(component.getTargetClass());
            subcomponentModel.setTargetClass(ClassName.parseName(subcomponent.generate()));
            subcomponentModel.setGenerate(!Strings.isEmpty(subcomponent.generate()));
            this.setComponentProperties(null, subcomponentModel, subAnnotation);
            library.getComponents().add(subcomponentModel);
        }
    }

    void setComponentProperties(TypeElement componentElement, ComponentModel component, JsfComponent annotation) throws CdkException {
        this.setComponentType(componentElement, component, annotation.type());
        this.setComponeneFamily(componentElement, component, annotation.family());
        this.setDescription(component, annotation.description(), this.getDocComment(componentElement));
        this.setRendererType(component, annotation.renderer());
        this.processFacets(componentElement, component, annotation);
        this.processAttributes(componentElement, component, annotation);
        this.processEvents(componentElement, component, annotation);
        for (Tag tag : annotation.tag()) {
            this.setTagInfo(tag, component);
        }
    }

    private void setRendererType(ComponentModel component, JsfRenderer jsfRenderer) {
        component.setRendererType(FacesId.parseId(jsfRenderer.type()));
    }

    /*
     * WARNING - void declaration
     */
    private void processAttributes(TypeElement componentElement, ComponentModel component, JsfComponent annotation) {
        AttributesProcessor attributesProcessor = this.getAttributeProcessor();
        attributesProcessor.processXmlFragment(component, annotation.attributes());
        if (componentElement != null) {
            attributesProcessor.processType(component, componentElement);
        }
        Collection<ClassName> interfaceNames = component.getInterfaces();
        try {
            void var9_14;
            Class[] interfaces;
            Class[] arr$ = interfaces = annotation.interfaces();
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_14 < len$) {
                Class clazz = arr$[var9_14];
                interfaceNames.add(new ClassName(clazz));
                ++var9_14;
            }
        }
        catch (MirroredTypesException e) {
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            for (TypeMirror typeMirror : typeMirrors) {
                this.processInterface(component, attributesProcessor, typeMirror);
            }
        }
        catch (MirroredTypeException e) {
            this.processInterface(component, attributesProcessor, e.getTypeMirror());
        }
    }

    private void processInterface(ComponentModel component, AttributesProcessor attributesProcessor, TypeMirror mirror) {
        component.getInterfaces().add(ClassName.parseName(((Object)mirror).toString()));
        if (TypeKind.DECLARED.equals((Object)mirror.getKind())) {
            attributesProcessor.processType(component, this.getSourceUtils().asTypeElement(mirror));
        }
    }

    void setComponentType(TypeElement componentElement, ComponentModel component, String type) {
        Object value;
        if (!Strings.isEmpty(type)) {
            component.setId(FacesId.parseId(type));
        } else if (null != componentElement && (value = this.getSourceUtils().getConstant(componentElement, COMPONENT_TYPE)) != null) {
            component.setId(FacesId.parseId(value.toString()));
        }
    }

    final void processFacets(TypeElement componentElement, ComponentModel component, JsfComponent annotation) {
        FacetModel facetModel;
        if (null != componentElement) {
            SourceUtils sourceUtils = this.getSourceUtils();
            Set<SourceUtils.BeanProperty> properties = sourceUtils.getBeanPropertiesAnnotatedWith(Facet.class, componentElement);
            for (SourceUtils.BeanProperty beanProperty : properties) {
                Facet facet = beanProperty.getAnnotation(Facet.class);
                facetModel = component.getOrCreateFacet(beanProperty.getName());
                facetModel.setDescription(beanProperty.getDocComment());
                this.processFacet(facet, facetModel, beanProperty.getDocComment());
                if (beanProperty.isExists()) continue;
                facetModel.setGenerate(true);
            }
        }
        for (Facet facet : annotation.facets()) {
            String name = facet.name();
            if (Strings.isEmpty(name)) {
                throw new CdkException("Facet name should be set");
            }
            facetModel = component.getOrCreateFacet(name);
            this.processFacet(facet, facetModel, null);
        }
    }

    final void processFacet(Facet facet, FacetModel facetModel, String docComment) {
        this.setDescription(facetModel, facet.description(), docComment);
        facetModel.setGenerate(facet.generate());
    }

    final void setComponeneFamily(TypeElement componentElement, ComponentModel component, String family) {
        Object value;
        if (!Strings.isEmpty(family)) {
            component.setFamily(FacesId.parseId(family));
        } else if (null != componentElement && null != (value = this.getSourceUtils().getConstant(componentElement, COMPONENT_FAMILY))) {
            component.setFamily(FacesId.parseId(value.toString()));
        }
    }

    final void processEvents(TypeElement componentElement, ComponentModel component, JsfComponent annotation) {
        try {
            Class[] fires;
            for (Class event : fires = annotation.fires()) {
                try {
                    component.addEvent(event.getName());
                }
                catch (MirroredTypesException mirror) {
                    for (TypeMirror typeMirror : mirror.getTypeMirrors()) {
                        component.addEvent(((Object)typeMirror).toString());
                    }
                }
                catch (MirroredTypeException mirror) {
                    component.addEvent(((Object)mirror.getTypeMirror()).toString());
                }
            }
        }
        catch (MirroredTypesException mirror) {
            for (TypeMirror typeMirror : mirror.getTypeMirrors()) {
                component.addEvent(((Object)typeMirror).toString());
            }
        }
        catch (MirroredTypeException mirror) {
            component.addEvent(((Object)mirror.getTypeMirror()).toString());
        }
    }

    @Override
    public final Class<? extends Annotation> getProcessedAnnotation() {
        return JsfComponent.class;
    }
}

