/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.JsfConverter;
import org.richfaces.cdk.apt.processors.AttributesProcessor;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ConverterModel;
import org.richfaces.cdk.model.FacesId;

@SupportedAnnotationTypes(value={"javax.faces.component.FacesComponent", "org.richfaces.cdk.annotations.JsfConverter"})
public class ConverterProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        ConverterModel converterModel;
        JsfConverter converter;
        block3: {
            converter = element.getAnnotation(JsfConverter.class);
            converterModel = new ConverterModel();
            converterModel.setId(FacesId.parseId(converter.id()));
            try {
                Class forClass = converter.forClass();
                if (!JsfConverter.NONE.class.equals((Object)forClass)) {
                    converterModel.setConverterForClass(new ClassName(forClass.getName()));
                }
            }
            catch (MirroredTypeException e) {
                String name = ((Object)e.getTypeMirror()).toString();
                if (JsfConverter.NONE.class.getName().equals(name)) break block3;
                converterModel.setConverterForClass(new ClassName(name));
            }
        }
        this.setDescription(converterModel, converter.description(), this.getDocComment(element));
        AttributesProcessor attributesProcessor = this.getAttributeProcessor();
        attributesProcessor.processXmlFragment(converterModel, converter.attributes());
        attributesProcessor.processType(converterModel, (TypeElement)element);
        this.setClassNames((TypeElement)element, converterModel, converter.generate());
        this.setTagInfo(converter.tag(), converterModel);
        library.getConverters().add(converterModel);
    }

    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return JsfConverter.class;
    }

    protected String[] getAnnotationAttributes(TypeElement element) {
        JsfConverter converter = element.getAnnotation(JsfConverter.class);
        return converter.attributes();
    }
}

