/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.Event;
import org.richfaces.cdk.annotations.Tag;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.util.Strings;

public class EventProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return Event.class;
    }

    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        if (ElementKind.CLASS.equals((Object)element.getKind())) {
            TypeElement eventType = (TypeElement)element;
            Event event = eventType.getAnnotation(Event.class);
            EventModel model = new EventModel();
            model.setType(ClassName.parseName(eventType.getQualifiedName().toString()));
            try {
                model.setListenerInterface(ClassName.parseName(event.listener().toString()));
            }
            catch (MirroredTypeException mirror) {
                model.setListenerInterface(ClassName.parseName(((Object)mirror.getTypeMirror()).toString()));
            }
            String listenerMethod = event.listenerMethod();
            if (!Strings.isEmpty(listenerMethod)) {
                model.setListenerMethod(listenerMethod);
            }
            model.setSourceInterface(ClassName.parseName(event.source()));
            for (Tag tag : event.tag()) {
                if (TagType.None.equals((Object)tag.type())) continue;
                model.getTags().add(this.processTag(tag));
            }
            library.getEvents().add(model);
        }
    }
}

