/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.Function;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.FunctionModel;
import org.richfaces.cdk.util.Strings;

public class FunctionProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return Function.class;
    }

    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        switch (element.getKind()) {
            case METHOD: {
                ExecutableElement methodElement = (ExecutableElement)element;
                Set<Modifier> modifiers = methodElement.getModifiers();
                if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                    throw new CdkProcessingException("Only public method can be registered as EL function " + methodElement.getSimpleName());
                }
                if (!modifiers.contains((Object)Modifier.STATIC)) {
                    throw new CdkProcessingException("Only static method can be registered as EL function " + methodElement.getSimpleName());
                }
                Function function = methodElement.getAnnotation(Function.class);
                FunctionModel model = new FunctionModel();
                if (!Strings.isEmpty(function.name())) {
                    model.setName(function.name());
                } else {
                    model.setName(methodElement.getSimpleName().toString());
                }
                model.setType(function.type());
                this.setDescription(model, function.description(), this.getDocComment(methodElement));
                StringBuilder signature = new StringBuilder();
                signature.append(methodElement.getReturnType()).append(" ");
                signature.append(methodElement.getSimpleName()).append("(");
                boolean first = true;
                for (VariableElement variableElement : methodElement.getParameters()) {
                    if (!first) {
                        signature.append(",");
                    }
                    signature.append(variableElement.asType());
                    first = false;
                }
                signature.append(")");
                model.setSignature(signature.toString());
                Element declaringClass = methodElement.getEnclosingElement();
                if (ElementKind.CLASS.equals((Object)declaringClass.getKind())) {
                    model.setFunctionClass(ClassName.parseName(((TypeElement)declaringClass).getQualifiedName().toString()));
                }
                library.getFunctions().add(model);
                break;
            }
            case CLASS: {
                break;
            }
        }
    }
}

