/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Source;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.annotations.JsfComponent;
import org.richfaces.cdk.annotations.JsfRenderer;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.templatecompiler.RendererTemplateParser;
import org.richfaces.cdk.util.Strings;

@SupportedAnnotationTypes(value={"javax.faces.component.FacesComponent", "org.richfaces.cdk.annotations.JsfRenderer"})
public class RendererProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    private static final String COMPONENT_FAMILY = "COMPONENT_FAMILY";
    private static final String RENDERER_TYPE = "RENDERER_TYPE";
    @Inject
    @Source(value=Sources.RENDERER_TEMPLATES)
    private FileManager sources;
    @Inject
    private RendererTemplateParser templateParser;

    @Override
    public void process(Element rendererElement, ComponentLibrary library) {
        JsfRenderer annotation = rendererElement.getAnnotation(JsfRenderer.class);
        RendererModel rendererModel = this.process((TypeElement)rendererElement, annotation, library);
        this.addToRenderKit(annotation, library, rendererModel);
    }

    public RendererModel process(TypeElement rendererElement, JsfRenderer annotation, ComponentLibrary library) {
        RendererModel rendererModel = new RendererModel();
        this.setClassNames(rendererElement, rendererModel, null);
        this.setRendererType(rendererElement, rendererModel, annotation);
        this.setComponentType(rendererModel);
        this.setComponentFamily(rendererElement, rendererModel, annotation);
        this.setDescription(rendererModel, annotation.description(), this.getDocComment(rendererElement));
        this.setTemplate(rendererModel, annotation);
        return rendererModel;
    }

    public RendererModel process(JsfRenderer renderer, ComponentLibrary library) {
        RendererModel rendererModel = new RendererModel();
        return rendererModel;
    }

    protected void setClassNames(TypeElement componentElement, RendererModel modelElement, String generatedClass) {
        if (componentElement.getModifiers().contains((Object)Modifier.ABSTRACT) || !Strings.isEmpty(generatedClass)) {
            modelElement.setGenerate(true);
            modelElement.setRendererClass(ClassName.parseName(generatedClass));
            modelElement.setBaseClass(ClassName.parseName(componentElement.getQualifiedName().toString()));
        } else {
            modelElement.setGenerate(false);
            modelElement.setRendererClass(ClassName.parseName(componentElement.getQualifiedName().toString()));
            TypeMirror superclass = componentElement.getSuperclass();
            if (superclass.getKind() == TypeKind.DECLARED) {
                TypeElement typeElement = this.getSourceUtils().asTypeElement(superclass);
                modelElement.setBaseClass(ClassName.parseName(typeElement.getQualifiedName().toString()));
            }
        }
    }

    private void setComponentType(RendererModel rendererModel) {
    }

    private void addToRenderKit(JsfRenderer annotation, ComponentLibrary library, RendererModel rendererModel) {
        String renderKitId = annotation.renderKitId();
        if (Strings.isEmpty(renderKitId)) {
            renderKitId = "HTML_BASIC";
        }
        library.addRenderer(renderKitId, rendererModel);
    }

    private void setTemplate(RendererModel rendererModel, JsfRenderer annotation) {
        String template = annotation.template();
        if (!Strings.isEmpty(template)) {
            rendererModel.setTemplatePath(template);
            this.processRendererTemplate(rendererModel);
        }
    }

    private void processRendererTemplate(RendererModel renderer) {
        String templatePath = renderer.getTemplatePath();
        try {
            File file = this.sources.getFile(templatePath);
            this.templateParser.build(file, renderer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void setComponentFamily(TypeElement rendererElement, RendererModel rendererModel, JsfRenderer annotation) {
        String family = annotation.family();
        if (!Strings.isEmpty(family)) {
            rendererModel.setFamily(FacesId.parseId(family));
            return;
        }
        Object value = this.getSourceUtils().getConstant(rendererElement, COMPONENT_FAMILY);
        if (value != null) {
            rendererModel.setFamily(FacesId.parseId(value.toString()));
            return;
        }
    }

    private String getRendererType(TypeElement rendererElement, JsfRenderer annotation) {
        String type = annotation.type();
        if (!Strings.isEmpty(type)) {
            return type;
        }
        Object value = this.getSourceUtils().getConstant(rendererElement, RENDERER_TYPE);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private void setRendererType(TypeElement rendererElement, RendererModel rendererModel, JsfRenderer annotation) {
        rendererModel.setId(FacesId.parseId(this.getRendererType(rendererElement, annotation)));
    }

    protected String getComponentType(TypeElement componentElement) {
        JsfComponent annotation = componentElement.getAnnotation(JsfComponent.class);
        if (annotation != null) {
            return annotation.type();
        }
        return null;
    }

    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return JsfRenderer.class;
    }

    protected String[] getAnnotationAttributes(TypeElement componentElement) {
        return null;
    }
}

