/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.TagLibrary;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.Taglib;
import org.richfaces.cdk.util.Strings;

public class TagLibProcessor
implements CdkAnnotationProcessor {
    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return TagLibrary.class;
    }

    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        PackageElement packageElement;
        String preffix;
        String tlibVersion;
        String displayName;
        TagLibrary tagLibrary = element.getAnnotation(TagLibrary.class);
        Taglib taglibModel = library.getTaglib();
        if (null == taglibModel) {
            taglibModel = new Taglib();
        }
        taglibModel.setUri(tagLibrary.uri());
        String shortName = tagLibrary.shortName();
        if (!Strings.isEmpty(shortName)) {
            taglibModel.setShortName(shortName);
        }
        if (!Strings.isEmpty(displayName = tagLibrary.displayName())) {
            taglibModel.setDisplayName(displayName);
        }
        if (!Strings.isEmpty(tlibVersion = tagLibrary.tlibVersion())) {
            taglibModel.setTlibVersion(tlibVersion);
        }
        if (!Strings.isEmpty(preffix = tagLibrary.preffix())) {
            library.setPrefix(preffix);
        } else if (Strings.isEmpty(library.getPrefix()) && !Strings.isEmpty(preffix = (packageElement = (PackageElement)element).getQualifiedName().toString())) {
            library.setPrefix(preffix);
        }
        library.setTaglib(taglibModel);
    }
}

