/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.freemarker;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.richfaces.cdk.model.BehaviorModel;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.ConverterModel;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.EventName;
import org.richfaces.cdk.model.ModelElementBase;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.ValidatorModel;

public class ModelElementBaseTemplateModel
extends StringModel
implements TemplateModel {
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new ModelElementBaseTemplateModel((ModelElementBase)object, (BeansWrapper)wrapper);
        }
    };
    private final ModelElementBase model;
    private Set<EventName> eventNames;
    private final String name;

    public ModelElementBaseTemplateModel(ModelElementBase object, BeansWrapper wrapper) {
        super((Object)object, wrapper);
        this.model = object;
        this.name = this.model instanceof ComponentModel ? "Component" : (this.model instanceof BehaviorModel ? "Behavior" : (this.model instanceof ConverterModel ? "Converter" : (this.model instanceof ValidatorModel ? "Validator" : "UnknownModelElement")));
    }

    public String getAsString() {
        return this.name;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if ("requiredAttributes".equals(key)) {
            return this.requiredAttributes();
        }
        if ("generatedAttributes".equals(key)) {
            return this.generatedAttributes();
        }
        if ("tagAttributes".equals(key)) {
            return this.tagAttributes();
        }
        if ("eventNames".equals(key)) {
            return this.eventNames();
        }
        if ("defaultEvent".equals(key)) {
            return this.defaultEvent();
        }
        if ("importClasses".equals(key)) {
            return this.getImportClasses();
        }
        if ("implemented".equals(key)) {
            return this.getImplementedInterfaces();
        }
        return super.get(key);
    }

    public TemplateModel getImportClasses() throws TemplateModelException {
        TreeSet result = Sets.newTreeSet();
        for (PropertyBase entry : this.model.getAttributes()) {
            if (!entry.isGenerate() || this.isPredefined(entry)) continue;
            result.add(entry.getType());
        }
        result.addAll(this.model.getInterfaces());
        if (this.model instanceof ComponentModel) {
            ComponentModel component = (ComponentModel)this.model;
            for (EventModel event : component.getEvents()) {
                result.add(event.getSourceInterface());
                result.add(event.getListenerInterface());
            }
        }
        return this.wrapper.wrap((Object)result);
    }

    public TemplateModel getImplementedInterfaces() throws TemplateModelException {
        TreeSet result = Sets.newTreeSet();
        if (this.getEventNames().size() > 0) {
            result.add(ClassName.parseName("javax.faces.component.behavior.ClientBehaviorHolder"));
        }
        result.addAll(this.model.getInterfaces());
        if (this.model instanceof ComponentModel) {
            ComponentModel component = (ComponentModel)this.model;
            for (EventModel event : component.getEvents()) {
                result.add(event.getSourceInterface());
            }
        }
        return this.wrapper.wrap((Object)result);
    }

    public boolean isPredefined(PropertyBase property) {
        return property.isPrimitive() || this.isFromJavaLang(property.getType());
    }

    public boolean isFromJavaLang(ClassName type) {
        return "java.lang".equals(type.getPackage());
    }

    private TemplateModel eventNames() throws TemplateModelException {
        return this.wrapper.wrap(this.getEventNames());
    }

    private TemplateModel defaultEvent() throws TemplateModelException {
        Set<EventName> names = this.getEventNames();
        try {
            EventName defaultEvent = (EventName)Iterables.find(names, (Predicate)new Predicate<EventName>(){

                public boolean apply(EventName event) {
                    return event.isDefaultEvent();
                }
            });
            return this.wrapper.wrap((Object)defaultEvent);
        }
        catch (NoSuchElementException e) {
            return this.wrapper.wrap(null);
        }
    }

    private Set<EventName> getEventNames() {
        if (null == this.eventNames) {
            this.eventNames = Sets.newHashSet();
            for (PropertyBase property : this.model.getAttributes()) {
                this.eventNames.addAll(property.getEventNames());
            }
        }
        return this.eventNames;
    }

    private TemplateModel requiredAttributes() throws TemplateModelException {
        return this.wrapper.wrap((Object)Collections2.filter(this.model.getAttributes(), (Predicate)new Predicate<PropertyBase>(){

            public boolean apply(PropertyBase input) {
                return input.isRequired();
            }
        }));
    }

    private TemplateModel generatedAttributes() throws TemplateModelException {
        return this.wrapper.wrap((Object)Collections2.filter(this.model.getAttributes(), (Predicate)new Predicate<PropertyBase>(){

            public boolean apply(PropertyBase input) {
                return input.isGenerate();
            }
        }));
    }

    private TemplateModel tagAttributes() throws TemplateModelException {
        return this.wrapper.wrap((Object)Collections2.filter(this.model.getAttributes(), (Predicate)new Predicate<PropertyBase>(){

            public boolean apply(PropertyBase input) {
                return !input.isHidden() && !input.isReadOnly();
            }
        }));
    }
}

