/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.util.Strings;

public class PropertyModel
extends StringModel
implements TemplateModel {
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new PropertyModel((PropertyBase)object, (BeansWrapper)wrapper);
        }
    };
    private final PropertyBase property;

    public PropertyModel(PropertyBase object, BeansWrapper wrapper) {
        super((Object)object, wrapper);
        this.property = object;
    }

    public String getAsString() {
        return this.property.getName();
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object value;
        if ("getterName".equals(key)) {
            value = this.getGetterName();
        } else if ("setterName".equals(key)) {
            value = this.getSetterName();
        } else if ("name".equals(key)) {
            value = this.getAsString();
        } else if ("capitalizeName".equals(key)) {
            value = this.capitalizeName();
        } else if ("typeForCasting".equals(key)) {
            value = this.typeForCasting();
        } else if ("isBingingAttribute".equals(key)) {
            value = this.isBingingAttribute();
        } else if ("isBinging".equals(key)) {
            value = this.isBinging();
        } else if ("typeName".equals(key)) {
            value = this.getTypeName();
        } else if ("isPrimitive".equals(key)) {
            value = this.isPrimitive();
        } else {
            return super.get(key);
        }
        return this.wrapper.wrap(value);
    }

    public boolean isBingingAttribute() {
        return this.property.isBindingAttribute();
    }

    public boolean isBinging() {
        return this.property.isBinding();
    }

    public boolean isPrimitive() {
        return this.property.isPrimitive();
    }

    private String typeForCasting() {
        ClassName type = this.property.getType();
        return ClassName.getSimpleName(type.isPrimitive() ? type.getBoxingName() : type.getSimpleName());
    }

    public String getGetterName() {
        return this.property.getType().getGetterPrefix() + this.capitalizeName();
    }

    public String getSetterName() {
        return "set" + this.capitalizeName();
    }

    public String capitalizeName() {
        return Strings.firstToUpperCase(this.getAsString());
    }

    public boolean isFromJavaLang(ClassName type) {
        return "java.lang".equals(type.getPackage());
    }

    public String getTypeName() {
        ClassName type = this.property.getType();
        return this.isFromJavaLang(type) ? type.getSimpleName() : type.getName();
    }
}

