/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.java.taghandler;

import com.google.inject.Inject;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.generate.java.LibraryModel;
import org.richfaces.cdk.generate.java.taghandler.TagWithModel;
import org.richfaces.cdk.model.ModelElementBase;
import org.richfaces.cdk.model.TagModel;
import org.richfaces.cdk.model.Trackable;

public class TagHandlerClassGenerator {
    private static final String TAGHANDLER_TEMPLATE = "taghandler.ftl";
    private final FileManager output;
    private final FreeMarkerRenderer configuration;

    @Inject
    public TagHandlerClassGenerator(@LibraryModel FreeMarkerRenderer configuration, @Output(value=Outputs.JAVA_CLASSES) FileManager output) {
        this.configuration = configuration;
        this.output = output;
    }

    public boolean process(ModelElementBase model, TagModel tag) throws CdkException {
        try {
            Writer writer = this.getOutput(tag);
            this.configuration.writeTemplate(TAGHANDLER_TEMPLATE, new TagWithModel<ModelElementBase>(tag, model), writer);
            writer.close();
        }
        catch (IOException e) {
            throw new CdkException(e);
        }
        catch (TemplateException e) {
            throw new CdkException(e);
        }
        return false;
    }

    private Writer getOutput(TagModel tag) throws CdkException {
        long lastModified = Long.MIN_VALUE;
        if (tag instanceof Trackable) {
            lastModified = ((Trackable)((Object)tag)).lastModified();
        }
        try {
            return this.output.createOutput(this.getOutputFileName(tag), lastModified);
        }
        catch (IOException e) {
            throw new CdkException(e);
        }
    }

    private String getOutputFileName(TagModel tag) {
        return tag.getTargetClass().getName().replace('.', File.separatorChar) + ".java";
    }
}

