/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.taglib;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.cdk.model.BeanModelBase;
import org.richfaces.cdk.model.BehaviorModel;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.ConverterModel;
import org.richfaces.cdk.model.DescriptionGroup;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.FunctionModel;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.SimpleVisitor;
import org.richfaces.cdk.model.TagModel;
import org.richfaces.cdk.model.ValidatorModel;
import org.richfaces.cdk.util.Strings;

public class TaglibGeneratorVisitor
extends SimpleVisitor<Boolean, ComponentLibrary> {
    private static final String COMPONENT = "component";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String HANDLER_CLASS = "handler-class";
    private Document document = DocumentHelper.createDocument();
    private Element faceletTaglib;
    private boolean empty = true;

    public boolean isEmpty() {
        return this.empty;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public Boolean visitComponentLibrary(ComponentLibrary model, ComponentLibrary componentLibrary) {
        this.faceletTaglib = this.document.addElement("facelet-taglib", "http://java.sun.com/xml/ns/javaee");
        this.faceletTaglib.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.faceletTaglib.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-facelettaglibrary_2_0.xsd");
        this.faceletTaglib.addAttribute("version", "2.0");
        this.faceletTaglib.addAttribute("id", model.getTaglib().getShortName());
        this.faceletTaglib.addElement("namespace").addText(model.getTaglib().getUri());
        return null;
    }

    @Override
    public Boolean visitComponent(ComponentModel model, ComponentLibrary componentLibrary) {
        for (TagModel tagModel : model.getTags()) {
            if (TagType.Facelets != tagModel.getType() && TagType.All != tagModel.getType()) continue;
            Element tag = this.createTag(tagModel.getName());
            Element component = tag.addElement(COMPONENT);
            component.addElement(COMPONENT_TYPE).addText(model.getId().getType());
            FacesId rendererType = model.getRendererType();
            if (null != rendererType) {
                component.addElement(RENDERER_TYPE).addText(rendererType.toString());
            }
            this.addTagHandler(component, tagModel);
            this.appendAttributs(tag, model);
        }
        return null;
    }

    private boolean addTagHandler(Element parent, TagModel tag) {
        if (tag != null && tag.getTargetClass() != null) {
            parent.addElement(HANDLER_CLASS).addText(tag.getTargetClass().toString());
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitConverter(ConverterModel model, ComponentLibrary componentLibrary) {
        for (TagModel tagModel : model.getTags()) {
            if (!TagType.Facelets.equals((Object)tagModel.getType())) continue;
            Element tag = this.createTag(tagModel.getName());
            Element converter = tag.addElement("converter");
            converter.addElement("converter-id", model.getId().toString());
            this.addTagHandler(converter, tagModel);
            this.appendAttributs(tag, model);
        }
        return null;
    }

    @Override
    public Boolean visitValidator(ValidatorModel model, ComponentLibrary componentLibrary) {
        for (TagModel tagModel : model.getTags()) {
            if (!TagType.Facelets.equals((Object)tagModel.getType())) continue;
            Element tag = this.createTag(tagModel.getName());
            Element validator = tag.addElement("validator");
            validator.addElement("validator-id", model.getId().toString());
            this.addTagHandler(validator, tagModel);
            this.appendAttributs(tag, model);
        }
        return null;
    }

    private void appendAttributs(Element tag, BeanModelBase model) {
        for (PropertyBase entry : model.getAttributes()) {
            if (entry.isHidden() || entry.isReadOnly()) continue;
            this.createAttributeElement(tag, entry.getName(), entry);
        }
    }

    private Element createAttributeElement(Element tag, String name, PropertyBase attribute) {
        Element attr = tag.addElement("attribute");
        if (attribute.getDescription() != null) {
            attr.addElement("description").addText(attribute.getDescription());
        }
        attr.addElement("name").addText(name);
        attr.addElement("type").addText(attribute.getType().toString());
        return attr;
    }

    private Element createTag(String tagName) {
        Element tag = this.faceletTaglib.addElement("tag");
        tag.addElement("tag-name").addText(tagName);
        this.empty = false;
        return tag;
    }

    @Override
    public Boolean visitBehavior(BehaviorModel model, ComponentLibrary componentLibrary) {
        for (TagModel tagModel : model.getTags()) {
            if (!TagType.Facelets.equals((Object)tagModel.getType())) continue;
            Element tag = this.createTag(tagModel.getName());
            Element behavior = tag.addElement("behavior");
            behavior.addElement("behavior-id").addText(model.getId().toString());
            this.addTagHandler(behavior, tagModel);
            this.appendAttributs(tag, model);
        }
        return null;
    }

    @Override
    public Boolean visitFunction(FunctionModel model, ComponentLibrary componentLibrary) {
        if (TagType.Facelets.equals((Object)model.getType()) || TagType.All.equals((Object)model.getType())) {
            Element functionElement = this.faceletTaglib.addElement("function");
            this.addDescription(functionElement, model);
            functionElement.addElement("function-name").addText(model.getName());
            functionElement.addElement("function-class").addText(model.getFunctionClass().toString());
            functionElement.addElement("function-signature").addText(model.getSignature());
            this.empty = false;
        }
        return null;
    }

    @Override
    public Boolean visitEvent(EventModel model, ComponentLibrary param) {
        for (TagModel tagModel : model.getTags()) {
            if (!TagType.Facelets.equals((Object)tagModel.getType())) continue;
            Element tag = this.createTag(tagModel.getName());
            this.addTagHandler(tag, tagModel);
        }
        return null;
    }

    private void addDescription(Element parent, DescriptionGroup model) {
        if (!Strings.isEmpty(model.getDescription())) {
            parent.addElement("description").addText(model.getDescription());
        }
        if (!Strings.isEmpty(model.getDisplayname())) {
            parent.addElement("display-name").addText(model.getDisplayname());
        }
        if (null != model.getIcon()) {
            Element iconElement = parent.addElement("icon");
            if (!Strings.isEmpty(model.getIcon().getSmallIcon())) {
                iconElement.addElement("small-icon").addText(model.getIcon().getSmallIcon());
            }
            if (!Strings.isEmpty(model.getIcon().getLargeIcon())) {
                iconElement.addElement("large-icon").addText(model.getIcon().getLargeIcon());
            }
        }
    }
}

