/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import org.richfaces.cdk.util.Strings;

public class ClassName
implements Serializable,
Comparable<ClassName> {
    private static final long serialVersionUID = -846623207703750456L;
    private static final ImmutableMap<String, String> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)Boolean.TYPE.getName(), (Object)Boolean.class.getName()).put((Object)Byte.TYPE.getName(), (Object)Byte.class.getName()).put((Object)Character.TYPE.getName(), (Object)Character.class.getName()).put((Object)Short.TYPE.getName(), (Object)Short.class.getName()).put((Object)Integer.TYPE.getName(), (Object)Integer.class.getName()).put((Object)Long.TYPE.getName(), (Object)Long.class.getName()).put((Object)Float.TYPE.getName(), (Object)Float.class.getName()).put((Object)Double.TYPE.getName(), (Object)Double.class.getName()).build();
    private final String boxingClassName;
    private final String fullName;
    private final String name;
    private final boolean primitive;
    private String typeParameters;

    public ClassName(Class<?> cl) {
        this(cl.getName());
    }

    public ClassName(String name) {
        this.fullName = name;
        if (PRIMITIVE_TYPES.containsKey((Object)name)) {
            this.name = name;
            this.boxingClassName = (String)PRIMITIVE_TYPES.get((Object)name);
            this.primitive = true;
        } else {
            int i = name.indexOf(60);
            if (i > 0) {
                this.name = name.substring(0, i);
                this.typeParameters = name.substring(i);
            } else {
                this.name = name;
            }
            this.boxingClassName = name;
            this.primitive = false;
        }
    }

    public static ClassName parseName(String name) {
        return Strings.isEmpty(name) ? null : new ClassName(name);
    }

    public static ClassName get(String name) {
        if (name == null) {
            return null;
        }
        return new ClassName(name);
    }

    public static ClassName get(Class name) {
        if (name == null) {
            return null;
        }
        return new ClassName(name);
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(String typeParameters) {
        this.typeParameters = typeParameters;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        int indexOfPeriod = this.name.lastIndexOf(46);
        if (indexOfPeriod > 0) {
            return this.name.substring(0, indexOfPeriod);
        }
        return null;
    }

    public String getSimpleName() {
        return ClassName.getSimpleName(this.name);
    }

    public static String getSimpleName(String name) {
        int indexOfPeriod = name.lastIndexOf(46);
        if (indexOfPeriod > 0) {
            return name.substring(indexOfPeriod + 1);
        }
        return name;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String getBoxingName() {
        return this.boxingClassName;
    }

    public String getGetterPrefix() {
        return Boolean.class.getName().equals(this.boxingClassName) ? "is" : "get";
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassName)) {
            return false;
        }
        ClassName other = (ClassName)obj;
        return !(this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName));
    }

    @Override
    public int compareTo(ClassName o) {
        return this.getName().compareTo(o.getName());
    }
}

