/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.FacetModel;
import org.richfaces.cdk.model.Merge;
import org.richfaces.cdk.model.ModelCollection;
import org.richfaces.cdk.model.ModelElement;
import org.richfaces.cdk.model.ModelElementBase;
import org.richfaces.cdk.model.ModelSet;
import org.richfaces.cdk.model.Named;
import org.richfaces.cdk.model.Visitor;

public final class ComponentModel
extends ModelElementBase
implements ModelElement<ComponentModel> {
    private static final long serialVersionUID = 2297349356280370771L;
    private final ModelCollection<FacetModel> facets = ModelSet.create();
    private final ModelCollection<EventModel> events = ModelSet.create();
    private FacesId family;
    private FacesId rendererType;

    public ComponentModel(FacesId key) {
        this.setId(key);
    }

    public ComponentModel() {
    }

    @Override
    public <R, D> R accept(Visitor<R, D> visitor, D data) {
        return visitor.visitComponent(this, data);
    }

    @Override
    public void merge(ComponentModel otherComponent) {
        ComponentLibrary.merge(this.getAttributes(), otherComponent.getAttributes());
        ComponentLibrary.merge(this.getFacets(), otherComponent.getFacets());
        ComponentLibrary.merge(this.getEvents(), otherComponent.getEvents());
        ComponentLibrary.merge(this, otherComponent);
        this.setGenerate(this.isGenerate() || otherComponent.isGenerate());
    }

    @Override
    public boolean same(ComponentModel other) {
        if (null != this.getId() && null != other.getId()) {
            return this.getId().equals(other.getId());
        }
        return null != this.getTargetClass() && this.getTargetClass().equals(other.getTargetClass());
    }

    @Merge
    public FacesId getRendererType() {
        return this.rendererType;
    }

    public void setRendererType(FacesId renderer) {
        this.rendererType = renderer;
    }

    @Merge
    public FacesId getFamily() {
        return this.family;
    }

    public void setFamily(FacesId family) {
        this.family = family;
    }

    public ModelCollection<FacetModel> getFacets() {
        return this.facets;
    }

    public FacetModel getFacet(String name) {
        return this.facets.find(new Named.NamePredicate(name));
    }

    public FacetModel getOrCreateFacet(String name) {
        FacetModel facet = this.getFacet(name);
        if (null == facet) {
            facet = new FacetModel();
            facet.setName(name);
            this.facets.add(facet);
        }
        return facet;
    }

    public ModelCollection<EventModel> getEvents() {
        return this.events;
    }

    public EventModel addEvent(String className) {
        EventModel event = new EventModel();
        event.setType(new ClassName(className));
        this.events.add(event);
        return event;
    }

    public String toString() {
        return "Component {type: " + this.getId() + ", family: " + this.getFamily() + "}";
    }
}

