/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.richfaces.cdk.model.ModelCollection;
import org.richfaces.cdk.model.ModelElement;
import org.richfaces.cdk.model.Visitor;

public class ModelSet<E extends ModelElement<? super E>>
implements ModelCollection<E>,
Set<E> {
    private final List<E> elements = Lists.newArrayList();
    private Comparator<E> comparator;

    public static <T extends ModelElement<? super T>> ModelSet<T> create() {
        return new ModelSet();
    }

    public static <T extends ModelElement<? super T>> ModelSet<T> create(Comparator<T> comparator) {
        ModelSet<T> collection = new ModelSet<T>();
        collection.setComparator(comparator);
        return collection;
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public E find(Predicate<? super E> predicate) {
        try {
            return (E)((ModelElement)Iterables.find(this.elements, predicate));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean add(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        for (ModelElement element : this.elements) {
            if (!element.same(e)) continue;
            element.merge(e);
            return false;
        }
        return this.elements.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (ModelElement e : c) {
            changed |= this.add((E)e);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (null != o) {
            Class<?> clazz = o.getClass();
            for (ModelElement element : this.elements) {
                if (!clazz.isInstance(element) || !element.same((ModelElement)o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        if (null == this.comparator) {
            return this.elements.iterator();
        }
        ArrayList list = Lists.newArrayList(this.elements);
        Collections.sort(list, this.comparator);
        return Iterators.unmodifiableIterator(list.iterator());
    }

    @Override
    public boolean remove(Object o) {
        if (null != o) {
            Class<?> clazz = o.getClass();
            for (ModelElement element : this.elements) {
                if (!clazz.isInstance(element) || !element.same((ModelElement)o)) continue;
                this.elements.remove(element);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object e : c) {
            changed |= this.remove(e);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.elements.toArray();
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public <R, D> R accept(R result, Visitor<R, D> visitor, D data) {
        return null == result ? this.accept(visitor, data) : result;
    }

    @Override
    public <R, D> R accept(Visitor<R, D> visitor, D data) {
        for (ModelElement element : this.elements) {
            R result = element.accept(visitor, data);
            if (null == result) continue;
            return result;
        }
        return null;
    }
}

