/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.DescriptionGroupBase;
import org.richfaces.cdk.model.EventName;
import org.richfaces.cdk.model.Merge;
import org.richfaces.cdk.model.ModelElement;
import org.richfaces.cdk.model.Named;
import org.richfaces.cdk.model.Visitor;
import org.richfaces.cdk.util.ComparatorUtils;

public abstract class PropertyBase
extends DescriptionGroupBase
implements ModelElement<PropertyBase>,
Named {
    private static final long serialVersionUID = 3483864006602184580L;
    private String name;
    private boolean hidden = false;
    private boolean literal = false;
    private boolean required = false;
    private boolean readOnly = false;
    private boolean passThrough = false;
    private Set<EventName> eventNames = Sets.newLinkedHashSet();
    private List<ClassName> signature = Lists.newArrayList();
    private String defaultValue;
    private String suggestedValue;
    private ClassName type;
    private boolean bindingAttribute;
    private boolean binding;
    private String aliasFor;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Merge
    public ClassName getType() {
        return this.type;
    }

    public void setType(ClassName type) {
        this.type = type;
    }

    @Merge
    public String getAliasFor() {
        return this.aliasFor;
    }

    public void setAliasFor(String aliasFor) {
        this.aliasFor = aliasFor;
    }

    @Merge
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String dafaultValue) {
        this.defaultValue = dafaultValue;
    }

    @Merge
    public String getSuggestedValue() {
        return this.suggestedValue;
    }

    public void setSuggestedValue(String suggestedValue) {
        this.suggestedValue = suggestedValue;
    }

    @Merge
    public Set<EventName> getEventNames() {
        return this.eventNames;
    }

    public void setEventNames(Set<EventName> eventNames) {
        this.eventNames = eventNames;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setLiteral(boolean literal) {
        this.literal = literal;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
    }

    @Merge(value=true)
    public List<ClassName> getSignature() {
        return this.signature;
    }

    public void setSignature(List<ClassName> signature) {
        this.signature = signature;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    @Override
    public void merge(PropertyBase other) {
        boolean generate = this.isGenerate();
        ComponentLibrary.merge(this, other);
        this.setGenerate(generate || other.isGenerate());
    }

    @Override
    public <R, D> R accept(Visitor<R, D> visitor, D data) {
        return visitor.visitProperty(this, data);
    }

    @Override
    public boolean same(PropertyBase other) {
        return ComparatorUtils.nullSafeEquals(this.getName(), other.getName());
    }

    public boolean isBindingAttribute() {
        return this.bindingAttribute;
    }

    public void setBindingAttribute(boolean bindingAttribute) {
        this.bindingAttribute = bindingAttribute;
    }

    public boolean isBinding() {
        return this.binding;
    }

    public void setBinding(boolean binding) {
        this.binding = binding;
    }

    public String toString() {
        return "PropertyModel {name: " + this.getName() + ", type: " + this.getType().getName() + "}";
    }
}

