/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import org.richfaces.cdk.model.BehaviorRendererModel;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.DescriptionGroupBase;
import org.richfaces.cdk.model.FacesComponent;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.Merge;
import org.richfaces.cdk.model.ModelCollection;
import org.richfaces.cdk.model.ModelElement;
import org.richfaces.cdk.model.ModelSet;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.model.Visitor;
import org.richfaces.cdk.util.ComparatorUtils;

public class RenderKitModel
extends DescriptionGroupBase
implements ModelElement<RenderKitModel>,
FacesComponent {
    private static final long serialVersionUID = -7387781530198813352L;
    private final ModelSet<RendererModel> renderers = ModelSet.create();
    private final ModelSet<BehaviorRendererModel> behaviorRenderers = ModelSet.create();
    private ClassName targetClass;
    private ClassName baseClass;
    private FacesId id;
    private boolean generate;

    @Override
    public FacesId getId() {
        return this.id;
    }

    @Override
    public void setId(FacesId id) {
        this.id = id;
    }

    @Override
    @Merge
    public ClassName getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void setTargetClass(ClassName renderKitClass) {
        this.targetClass = renderKitClass;
    }

    @Override
    public ClassName getBaseClass() {
        return this.baseClass;
    }

    @Override
    public void setBaseClass(ClassName baseClass) {
        this.baseClass = baseClass;
    }

    @Override
    public boolean isGenerate() {
        return this.generate;
    }

    @Override
    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public ModelCollection<RendererModel> getRenderers() {
        return this.renderers;
    }

    public ModelCollection<BehaviorRendererModel> getBehaviorRenderers() {
        return this.behaviorRenderers;
    }

    @Override
    public <R, D> R accept(Visitor<R, D> visitor, D data) {
        R result = visitor.visitRenderKit(this, data);
        result = this.renderers.accept(result, visitor, data);
        result = this.behaviorRenderers.accept(result, visitor, data);
        return result;
    }

    @Override
    public void merge(RenderKitModel other) {
        ComponentLibrary.merge(this.renderers, other.renderers);
        ComponentLibrary.merge(this.behaviorRenderers, other.behaviorRenderers);
        ComponentLibrary.merge(this, other);
    }

    @Override
    public boolean same(RenderKitModel other) {
        if (null != this.getId() && null != other.getId()) {
            return this.getId().equals(other.getId());
        }
        return ComparatorUtils.nullSafeEquals(this.getTargetClass(), other.getTargetClass());
    }
}

