/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model.validator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterHandler;
import javax.xml.validation.ValidatorHandler;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelValidator;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.model.BehaviorModel;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.DescriptionGroup;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.FacesComponent;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.FacetModel;
import org.richfaces.cdk.model.InvalidNameException;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.RenderKitModel;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.model.TagModel;
import org.richfaces.cdk.model.Taglib;
import org.richfaces.cdk.util.Strings;

public class ValidatorImpl
implements ModelValidator {
    public static final ClassName DEFAULT_COMPONENT_HANDLER = new ClassName(ComponentHandler.class);
    public static final ClassName DEFAULT_VALIDATOR_HANDLER = new ClassName(ValidatorHandler.class);
    public static final ClassName DEFAULT_CONVERTER_HANDLER = new ClassName(ConverterHandler.class);
    public static final ClassName DEFAULT_BEHAVIOR_HANDLER = new ClassName(BehaviorHandler.class);
    @Inject
    private Logger log;
    private final NamingConventions namingConventions;
    private final SourceUtils sourceUtils;

    @Inject
    public ValidatorImpl(NamingConventions namingConventions, SourceUtils sourceUtils) {
        this.namingConventions = namingConventions;
        this.sourceUtils = sourceUtils;
    }

    @Override
    public void verify(ComponentLibrary library) throws CdkException {
        this.verifyComponents(library);
        this.verifyEvents(library);
        this.verifyBehaviors(library);
        this.verifyRenderers(library);
        this.verifyTaglib(library);
    }

    protected void verifyEvents(ComponentLibrary library) {
        for (EventModel event : library.getEvents()) {
            ClassName sourceInterface;
            ClassName listenerInterface = event.getListenerInterface();
            if (null == listenerInterface) {
                // empty if block
            }
            event.setGenerateListener(null == this.sourceUtils.asTypeElement(listenerInterface));
            String methodName = event.getListenerMethod();
            if (null == methodName) {
                methodName = "process";
                event.setListenerMethod(methodName);
            }
            if (null == (sourceInterface = event.getSourceInterface())) {
                // empty if block
            }
            event.setGenerateSource(null == this.sourceUtils.asTypeElement(sourceInterface));
            for (ComponentModel component : library.getComponents()) {
                for (EventModel componentEvent : component.getEvents()) {
                    if (!event.getType().equals(componentEvent.getType())) continue;
                    componentEvent.merge(event);
                }
            }
        }
    }

    protected void verifyTaglib(ComponentLibrary library) {
        String shortName;
        String uri;
        Taglib taglib = library.getTaglib();
        if (null == taglib) {
            taglib = new Taglib();
            library.setTaglib(taglib);
        }
        if (null == (uri = taglib.getUri())) {
            uri = this.namingConventions.inferTaglibUri(library);
            taglib.setUri(uri);
        }
        if (null == (shortName = taglib.getShortName())) {
            shortName = this.namingConventions.inferTaglibName(uri);
            taglib.setShortName(shortName);
        }
    }

    protected void verifyBehaviors(ComponentLibrary library) {
        for (BehaviorModel behavior : library.getBehaviors()) {
            this.verifyTypes(behavior, new NamingConventionsCallback(){

                @Override
                public FacesId inferType(ClassName targetClass) {
                    return ValidatorImpl.this.namingConventions.inferBehaviorType(targetClass);
                }

                @Override
                public ClassName inferClass(FacesId id) {
                    return ValidatorImpl.this.namingConventions.inferBehaviorClass(id);
                }
            });
            for (TagModel tag : behavior.getTags()) {
                this.verifyTag(tag, behavior.getId(), DEFAULT_BEHAVIOR_HANDLER);
            }
        }
    }

    protected void verifyRenderers(ComponentLibrary library) {
        for (RenderKitModel renderKit : library.getRenderKits()) {
            for (RendererModel renderer : renderKit.getRenderers()) {
                this.vefifyRenderer(library, renderer);
            }
        }
    }

    protected void vefifyRenderer(ComponentLibrary library, RendererModel renderer) {
    }

    protected void verifyComponents(ComponentLibrary library) throws CdkException {
        for (ComponentModel component : library.getComponents()) {
            this.verifyComponentType(component);
        }
        HashSet verified = Sets.newHashSet();
        for (ComponentModel component : library.getComponents()) {
            this.verifyComponentAttributes(library, component, verified);
        }
    }

    protected void verifyComponentAttributes(ComponentLibrary library, final ComponentModel component, Collection<ComponentModel> verified) {
        if (!verified.contains(component)) {
            verified.add(component);
            if (null != component.getBaseClass()) {
                try {
                    ComponentModel parentComponent = (ComponentModel)Iterables.find(library.getComponents(), (Predicate)new Predicate<ComponentModel>(){

                        public boolean apply(ComponentModel input) {
                            return component.getBaseClass().equals(input.getTargetClass());
                        }
                    });
                    this.verifyComponentAttributes(library, parentComponent, verified);
                    for (PropertyBase parentAttribute : parentComponent.getAttributes()) {
                        PropertyBase attribute = component.getOrCreateAttribute(parentAttribute.getName());
                        attribute.merge(parentAttribute);
                        attribute.setGenerate(false);
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            for (PropertyBase attribute : component.getAttributes()) {
                this.verifyAttribute(attribute, component.isGenerate());
            }
            for (TagModel tag : component.getTags()) {
                this.verifyTag(tag, component.getId(), DEFAULT_COMPONENT_HANDLER);
            }
            this.verifyDescription(component);
            for (FacetModel facet : component.getFacets()) {
                this.verifyDescription(facet);
            }
        }
    }

    protected void verifyTag(TagModel tag, FacesId id, ClassName handler) {
        if (Strings.isEmpty(tag.getName())) {
            String defaultTagName = this.namingConventions.inferTagName(id);
            tag.setName(defaultTagName);
        }
        if (tag.isGenerate()) {
            if (null == tag.getBaseClass()) {
                tag.setBaseClass(handler);
            }
            if (null == tag.getTargetClass()) {
                this.namingConventions.inferTagHandlerClass(id, tag.getType().toString());
            }
        }
    }

    protected void verifyComponentType(ComponentModel component) throws InvalidNameException {
        if (this.verifyTypes(component, new NamingConventionsCallback(){

            @Override
            public FacesId inferType(ClassName targetClass) {
                return ValidatorImpl.this.namingConventions.inferComponentType(targetClass);
            }

            @Override
            public ClassName inferClass(FacesId id) {
                return ValidatorImpl.this.namingConventions.inferUIComponentClass(id);
            }
        }) && null == component.getFamily()) {
            component.setFamily(this.namingConventions.inferUIComponentFamily(component.getId()));
        }
    }

    protected boolean verifyTypes(FacesComponent component, NamingConventionsCallback callback) {
        if (null == component.getId()) {
            if (null != component.getTargetClass()) {
                component.setId(callback.inferType(component.getTargetClass()));
            } else if (null != component.getBaseClass()) {
                component.setId(callback.inferType(component.getBaseClass()));
            } else {
                this.log.error((CharSequence)("No type information available for component: " + component));
                return false;
            }
        }
        if (component.isGenerate()) {
            if (null == component.getBaseClass()) {
                this.log.error((CharSequence)("Base class for generated component is not set :" + component.getId()));
            } else if (null == component.getTargetClass()) {
                component.setTargetClass(callback.inferClass(component.getId()));
            }
        } else if (null == component.getTargetClass()) {
            if (null != component.getBaseClass()) {
                component.setTargetClass(component.getBaseClass());
            } else {
                this.log.error((CharSequence)("No class information available for component: " + component));
                return false;
            }
        }
        return true;
    }

    protected void verifyAttribute(PropertyBase attribute, boolean generatedComponent) {
        if (Strings.isEmpty(attribute.getName())) {
            this.log.error((CharSequence)("No name for attribute " + attribute));
            return;
        }
        if (attribute.getName().contains(".") || Character.isDigit(attribute.getName().charAt(0)) || attribute.getName().contains(" ")) {
            this.log.error((CharSequence)("Invalid attribute name [" + attribute.getName() + "]"));
            return;
        }
        if (null == attribute.getType()) {
            this.log.error((CharSequence)("Unknown type of attribute [" + attribute.getName() + "]"));
            return;
        }
        if ("javax.faces.el.MethodBinding".equals(attribute.getType().getName())) {
            attribute.setBinding(true);
            attribute.setBindingAttribute(true);
        } else if ("javax.el.MethodExpression".equals(attribute.getType().getName())) {
            attribute.setBindingAttribute(true);
        }
        if (!generatedComponent) {
            attribute.setGenerate(false);
        }
        this.verifyDescription(attribute);
    }

    protected void verifyDescription(DescriptionGroup element) {
    }

    static interface NamingConventionsCallback {
        public FacesId inferType(ClassName var1);

        public ClassName inferClass(FacesId var1);
    }
}

