/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelBuilder;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.RichFacesConventions;
import org.richfaces.cdk.Source;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.EventName;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.PropertyModel;
import org.richfaces.cdk.model.RenderKitModel;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.model.SimpleVisitor;
import org.richfaces.cdk.templatecompiler.model.Attribute;
import org.richfaces.cdk.templatecompiler.model.ClientBehavior;
import org.richfaces.cdk.templatecompiler.model.CompositeInterface;
import org.richfaces.cdk.templatecompiler.model.ImportAttributes;
import org.richfaces.cdk.templatecompiler.model.Template;
import org.richfaces.cdk.util.Strings;
import org.richfaces.cdk.xmlconfig.FragmentParser;
import org.richfaces.cdk.xmlconfig.JAXB;

public class RendererTemplateParser
implements ModelBuilder {
    private static final Pattern PARAMETERS_STRING_PATTERN = Pattern.compile("\\( ( [^\\)]* ) \\) \\s*$", 4);
    private static final Pattern COMMA_SEPARATED_PATTERN = Pattern.compile("\\s*,\\s*", 4);
    private ComponentLibrary library;
    private JAXB jaxbBinding;
    private Logger log;
    private FileManager sources;
    private FragmentParser fragmentParser;
    private NamingConventions namingConventions;

    @Inject
    public RendererTemplateParser(ComponentLibrary library, JAXB jaxbBinding, Logger log, @Source(value=Sources.RENDERER_TEMPLATES) FileManager sources, FragmentParser fragmentParser) {
        this.library = library;
        this.jaxbBinding = jaxbBinding;
        this.log = log;
        this.sources = sources;
        this.fragmentParser = fragmentParser;
    }

    private Set<EventName> convert(Collection<ClientBehavior> clientBehaviors) {
        if (clientBehaviors == null || clientBehaviors.isEmpty()) {
            return null;
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (ClientBehavior clientBehavior : clientBehaviors) {
            EventName eventName = new EventName();
            eventName.setName(clientBehavior.getEvent());
            eventName.setDefaultEvent(clientBehavior.isDefaultEvent());
            result.add(eventName);
        }
        return result;
    }

    private List<ClassName> parseSignature(String signatureString) {
        ArrayList result = Lists.newArrayList();
        if (!Strings.isEmpty(signatureString)) {
            Matcher parametersStringMatcher = PARAMETERS_STRING_PATTERN.matcher(signatureString);
            if (!parametersStringMatcher.find()) {
                throw new IllegalArgumentException(MessageFormat.format("Signature string {0} cannot be parsed!", signatureString));
            }
            String parametersString = parametersStringMatcher.group(1);
            if (parametersString.trim().length() != 0) {
                String[] parameters;
                for (String parameter : parameters = COMMA_SEPARATED_PATTERN.split(parametersString)) {
                    String trimmedParameter = parameter.trim();
                    result.add(ClassName.parseName(trimmedParameter));
                }
            }
        }
        return result;
    }

    @Override
    public void build() throws CdkException {
        Iterable<File> sourceFiles = this.sources.getFiles();
        if (null != sourceFiles) {
            for (File file : sourceFiles) {
                this.build(file, null);
            }
        }
    }

    public void build(File file, RendererModel rendererModel) {
        this.log.debug((CharSequence)"RendererTemplateParser.build");
        String absolutePath = file.getAbsolutePath();
        this.log.debug((CharSequence)("  - file = " + absolutePath));
        this.log.debug((CharSequence)("  - renderer = " + rendererModel));
        RendererModel existedModel = this.library.accept(new SimpleVisitor<RendererModel, String>(){

            @Override
            public RendererModel visitRender(RendererModel model, String absolutePath) {
                Template template = model.getTemplate();
                if (null != template && absolutePath.equals(template.getTemplatePath())) {
                    return model;
                }
                return null;
            }
        }, absolutePath);
        if (null != existedModel) {
            this.log.debug((CharSequence)"  - Template was already processed.");
            return;
        }
        Template template = this.parseTemplate(file);
        template.setTemplatePath(absolutePath);
        this.mergeTemplateIntoModel(template, rendererModel);
    }

    protected void mergeTemplateIntoModel(Template template, RendererModel renderer) throws CdkException {
        List<Attribute> templateAttributes;
        List<ImportAttributes> attributesImports;
        CompositeInterface compositeInterface = template.getInterface();
        if (renderer == null) {
            renderer = new RendererModel();
            RenderKitModel renderKit = this.library.addRenderKit(compositeInterface.getRenderKitId());
            renderKit.getRenderers().add(renderer);
        }
        renderer.setTemplate(template);
        this.setRendererType(template, compositeInterface, renderer);
        this.setFamily(compositeInterface, renderer);
        this.setRendererClass(compositeInterface, renderer);
        this.setRendererBaseClass(compositeInterface, renderer);
        Boolean rendersChildren = compositeInterface.getRendersChildren();
        if (rendersChildren != null) {
            renderer.setRendersChildren(rendersChildren);
        }
        if ((attributesImports = compositeInterface.getAttributesImports()) != null) {
            for (ImportAttributes attributesImport : attributesImports) {
                String importURI = attributesImport.getSource();
                Collection<PropertyBase> properties = this.fragmentParser.parseProperties(importURI);
                if (properties == null) continue;
                renderer.getAttributes().addAll(properties);
            }
        }
        if ((templateAttributes = compositeInterface.getAttributes()) != null) {
            for (Attribute templateAttribute : templateAttributes) {
                renderer.getAttributes().add(this.buildProperty(templateAttribute));
            }
        }
    }

    private PropertyModel buildProperty(Attribute templateAttribute) {
        PropertyModel rendererProperty = new PropertyModel();
        rendererProperty.setName(templateAttribute.getName());
        rendererProperty.setDefaultValue(templateAttribute.getDefaultValue());
        rendererProperty.setDescription(templateAttribute.getShortDescription());
        rendererProperty.setDisplayname(templateAttribute.getDisplayName());
        Set<EventName> eventNamesSet = this.convert(templateAttribute.getClientBehaviors());
        if (eventNamesSet != null) {
            rendererProperty.getEventNames().addAll(eventNamesSet);
        }
        rendererProperty.setRequired(templateAttribute.isRequired());
        List<ClassName> parsedSignature = this.parseSignature(templateAttribute.getMethodSignature());
        rendererProperty.getSignature().addAll(parsedSignature);
        rendererProperty.setType(templateAttribute.getType());
        return rendererProperty;
    }

    private void setRendererClass(CompositeInterface compositeInterface, RendererModel renderer) {
        renderer.setRendererClass(compositeInterface.getJavaClass());
    }

    private void setRendererBaseClass(CompositeInterface compositeInterface, RendererModel renderer) {
        renderer.setBaseClass(compositeInterface.getBaseClass());
    }

    private void setFamily(CompositeInterface compositeInterface, RendererModel renderer) {
        renderer.setFamily(compositeInterface.getComponentFamily());
    }

    private void setRendererType(Template template, CompositeInterface compositeInterface, RendererModel renderer) {
        renderer.setId(compositeInterface.getRendererType());
    }

    protected Template parseTemplate(File file) throws CdkException {
        return this.jaxbBinding.unmarshal(file, "http://richfaces.org/cdk/cdk-template.xsd", Template.class);
    }

    public NamingConventions getNamingConventions() {
        if (this.namingConventions == null) {
            this.namingConventions = new RichFacesConventions();
        }
        return this.namingConventions;
    }

    public void setNamingConventions(NamingConventions namingConventions) {
        this.namingConventions = namingConventions;
    }
}

