/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.builder.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.render.Renderer;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.templatecompiler.builder.model.ClassImport;
import org.richfaces.cdk.templatecompiler.builder.model.JavaAnnotation;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.JavaLanguageElement;
import org.richfaces.cdk.templatecompiler.builder.model.JavaMethod;
import org.richfaces.cdk.templatecompiler.builder.model.JavaPackage;
import org.richfaces.cdk.templatecompiler.builder.model.RuntimeImport;

public class JavaClass
extends JavaLanguageElement {
    private static final ClassName DEFAULT_SUPERCLASS = ClassName.get(Renderer.class);
    private List<JavaField> fields = new ArrayList<JavaField>();
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private Set<JavaImport> imports = new TreeSet<JavaImport>(JavaImport.COMPARATOR);
    private ClassName superClass = DEFAULT_SUPERCLASS;
    private final JavaPackage pakg;
    private final String simpleName;

    public JavaClass(String simpleName, JavaPackage pakg) {
        super(JavaClass.getFullName(pakg, simpleName));
        this.pakg = pakg;
        this.simpleName = simpleName;
    }

    public JavaClass(ClassName javaClass) {
        this(javaClass.getSimpleName(), new JavaPackage(javaClass.getPackage()));
    }

    private static String getFullName(JavaPackage javaPackage, String className) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(javaPackage.getName());
        if (fullName.length() != 0) {
            fullName.append('.');
        }
        fullName.append(className);
        return fullName.toString();
    }

    public void addImport(String name) {
        this.addImport(new RuntimeImport(name));
    }

    public void addImport(JavaImport javaImport) {
        this.imports.add(javaImport);
    }

    public void addImport(Class<?> claz) {
        if (this.shouldAddToImports(claz.getName())) {
            this.imports.add(new ClassImport(claz));
        }
    }

    public void addImports(Iterable<JavaImport> imports) {
        for (JavaImport elType : imports) {
            this.addImport(elType);
        }
    }

    @Override
    public void addAnnotation(JavaAnnotation annotation) {
        super.addAnnotation(annotation);
        this.addImports(annotation.getRequiredImports());
    }

    public void addField(JavaField field) {
        this.fields.add(field);
        this.addImports(field.getRequiredImports());
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
        this.addImports(method.getRequiredImports());
    }

    public JavaPackage getPakg() {
        return this.pakg;
    }

    public ClassName getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(ClassName superClass) {
        this.superClass = superClass;
        this.addImport(superClass.getName());
    }

    public JavaPackage getPackage() {
        return this.pakg;
    }

    public List<JavaField> getFields() {
        return this.fields;
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public Set<JavaImport> getImports() {
        return this.imports;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    private boolean shouldAddToImports(String className) {
        if (className == null || className.length() == 0) {
            return false;
        }
        if (className.indexOf(46) == -1) {
            return false;
        }
        return !className.matches("^java\\.lang\\.[^\\.]+$");
    }
}

