/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el;

import com.google.inject.Inject;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ELVisitor;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class ELParserImpl
implements ELParser {
    private final TypesFactory typesFactory;
    private final Logger log;

    @Inject
    public ELParserImpl(TypesFactory typesFactory, Logger log) {
        this.typesFactory = typesFactory;
        this.log = log;
    }

    @Override
    public TypedTemplateStatement parse(String expression, Variables variables, ELType expectedType) throws ParsingException {
        ELVisitor visitor = new ELVisitor(this.log, this.typesFactory);
        visitor.parse(expression, variables, expectedType);
        return visitor;
    }

    @Override
    public TypedTemplateStatement parse(String expression, Variables variables, String expectedType) throws ParsingException {
        return this.parse(expression, variables, this.typesFactory.getType(expectedType));
    }

    @Override
    public ELType getType(Class<?> targetClass) {
        return this.typesFactory.getType(targetClass);
    }

    @Override
    public ELType getType(String classExpression) {
        return this.typesFactory.getType(classExpression);
    }

    @Override
    public ELType getType(ClassName targetClass) {
        return this.typesFactory.getType(targetClass.toString());
    }
}

