/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.node;

import org.jboss.el.parser.Node;
import org.richfaces.cdk.templatecompiler.el.ELVisitor;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.node.AbstractTreeNode;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;

public class EqualityTestTreeNode
extends AbstractTreeNode {
    private boolean negateValue = false;

    public EqualityTestTreeNode(Node node) {
        super(node);
    }

    public EqualityTestTreeNode(Node node, boolean negateValue) {
        super(node);
        this.negateValue = negateValue;
    }

    private boolean isPrimitive(ELType type) {
        return type.isPrimitive();
    }

    private boolean useIsEqualsMethod(ELType firstType, ELType secondType) {
        if (firstType.isNullType() && !this.isPrimitive(secondType)) {
            return false;
        }
        if (secondType.isNullType() && !this.isPrimitive(firstType)) {
            return false;
        }
        return !this.isPrimitive(firstType) || !this.isPrimitive(secondType);
    }

    @Override
    public void visit(StringBuilder sb, ELVisitor visitor) throws ParsingException {
        String firstChildOutput = this.getChildOutput(0, visitor);
        ELType firstChildType = visitor.getType();
        String secondChildOutput = this.getChildOutput(1, visitor);
        ELType secondChildType = visitor.getType();
        if (this.useIsEqualsMethod(firstChildType, secondChildType)) {
            if (this.negateValue) {
                sb.append("!");
            }
            sb.append(HelperMethod.EQUALS_CHECK.getName());
            sb.append("(");
            sb.append(firstChildOutput);
            sb.append(",");
            sb.append(secondChildOutput);
            sb.append(")");
            visitor.addHelperMethods(HelperMethod.EQUALS_CHECK);
        } else {
            sb.append("(");
            sb.append(firstChildOutput);
            if (this.negateValue) {
                sb.append(" != ");
            } else {
                sb.append(" == ");
            }
            sb.append(secondChildOutput);
            sb.append(")");
        }
        visitor.setLiteral(false);
        visitor.setExpressionType(TypesFactory.BOOLEAN_TYPE);
    }
}

