/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.types;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.richfaces.cdk.templatecompiler.builder.model.ClassImport;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactoryImpl;

public final class PlainClassType
implements ELType {
    public static final ELType[] NO_TYPES = new ELType[0];
    private final Class<?> clazz;
    private final Set<JavaImport> imports;

    public PlainClassType(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Array classes are not supported");
        }
        this.clazz = clazz;
        this.imports = Collections.singleton(new ClassImport(clazz));
    }

    public Class<?> getPlainJavaClass() {
        return this.clazz;
    }

    @Override
    public String getCode() {
        return this.clazz.getSimpleName();
    }

    @Override
    public String getRawName() {
        return this.clazz.getName();
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return this.imports;
    }

    @Override
    public boolean isNullType() {
        return false;
    }

    @Override
    public ELType getRawType() {
        return this;
    }

    @Override
    public ELType[] getTypeArguments() {
        return NO_TYPES;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlainClassType other = (PlainClassType)obj;
        return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
    }

    public String toString() {
        return MessageFormat.format("{0}: {1}", this.getClass().getName(), this.clazz.toString());
    }

    @Override
    public ELType getContainerType() {
        return TypesFactory.OBJECT_TYPE;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isAssignableFrom(ELType anotherType) {
        if (Object.class.equals(this.clazz)) {
            return true;
        }
        if (anotherType.isNullType()) {
            return !this.clazz.isPrimitive();
        }
        if (anotherType instanceof PlainClassType) {
            Class boxedClass = this.clazz.isPrimitive() ? (Class)TypesFactoryImpl.PRIMITIVE_TO_WRAPPER_CLASSES_MAP.get(this.clazz) : this.clazz;
            Class clazz2 = ((PlainClassType)anotherType).clazz;
            clazz2 = clazz2.isPrimitive() ? (Class)TypesFactoryImpl.PRIMITIVE_TO_WRAPPER_CLASSES_MAP.get(clazz2) : clazz2;
            return boxedClass.isAssignableFrom(clazz2);
        }
        return this.getRawName().equals(anotherType.getRawName());
    }

    @Override
    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }
}

