/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatement;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;
import org.richfaces.cdk.util.Strings;

public class DefineObjectStatement
extends FreeMarkerTemplateStatementBase {
    private ELType type;
    private String name;
    private final ELParser parser;
    private final Logger log;
    private final TypesFactory typesFactory;
    private TypedTemplateStatement initializationStatement;

    @Inject
    public DefineObjectStatement(Logger log, @TemplateModel FreeMarkerRenderer renderer, ELParser parser, TypesFactory typesFactory) {
        super(renderer, "define-object");
        this.log = log;
        this.parser = parser;
        this.typesFactory = typesFactory;
    }

    public void setObject(String name, String type, String initializationExpression) {
        try {
            this.name = name;
            if (!Strings.isEmpty(initializationExpression)) {
                this.initializationStatement = this.parser.parse(initializationExpression, (Variables)this, TypesFactory.OBJECT_TYPE);
                this.initializationStatement.setParent(this);
                this.type = this.initializationStatement.getType();
            } else {
                this.type = TypesFactory.OBJECT_TYPE;
            }
            if (!Strings.isEmpty(type)) {
                this.type = this.typesFactory.getType(type);
                this.addImports(this.type.getRequiredImports());
            }
        }
        catch (ParsingException e) {
            this.log.error((CharSequence)("Error parse initialization expression for variable " + name), (Throwable)e);
        }
    }

    public ELType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public TypedTemplateStatement getInitializationStatement() {
        return this.initializationStatement;
    }

    @Override
    public List<TemplateStatement> getStatements() {
        return null != this.initializationStatement ? Collections.singletonList(this.initializationStatement) : Collections.emptyList();
    }
}

