/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class ForEachStatement
extends FreeMarkerTemplateStatementBase {
    private TypedTemplateStatement itemsStatement;
    private String var;
    private ELType varType;
    private final ELParser parser;
    private final Logger log;

    @Inject
    public ForEachStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger log) {
        super(renderer, "for-each");
        this.parser = parser;
        this.log = log;
    }

    public TypedTemplateStatement getItemsExpression() {
        return this.itemsStatement;
    }

    public String getVar() {
        return this.var;
    }

    public ELType getVarType() {
        return this.varType;
    }

    public void setItemsExpression(String itemsExpression, String var) {
        try {
            this.itemsStatement = this.parser.parse(itemsExpression, (Variables)this, Iterable.class.getName());
            this.itemsStatement.setParent(this);
            this.varType = this.itemsStatement.getType().getContainerType();
            this.var = var;
            this.setVariable(var, this.varType);
        }
        catch (ParsingException e) {
            this.log.error((CharSequence)"Error parsing expression for iteration in <foreach> statement", (Throwable)e);
        }
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return Iterables.concat(super.getRequiredImports(), this.itemsStatement.getRequiredImports());
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        return Iterables.concat(super.getRequiredMethods(), this.itemsStatement.getRequiredMethods());
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        return Iterables.concat(super.getRequiredFields(), this.itemsStatement.getRequiredFields());
    }
}

